-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Sep 29, 2025 at 02:21 PM
-- Server version: 5.7.44
-- PHP Version: 8.1.33

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `dovishhh_oceanbay`
--

-- --------------------------------------------------------

--
-- Table structure for table `areas`
--

CREATE TABLE `areas` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `area_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `areas`
--

INSERT INTO `areas` (`id`, `branch_id`, `area_name`, `created_at`, `updated_at`) VALUES
(1, 3, 'Buddha', '2025-05-29 13:08:18', '2025-05-29 13:08:18'),
(2, 3, 'Haccienda', '2025-05-29 13:08:48', '2025-05-29 13:08:48');

-- --------------------------------------------------------

--
-- Table structure for table `branches`
--

CREATE TABLE `branches` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `lat` decimal(10,7) DEFAULT NULL,
  `lng` decimal(10,7) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `branches`
--

INSERT INTO `branches` (`id`, `restaurant_id`, `name`, `address`, `created_at`, `updated_at`, `lat`, `lng`) VALUES
(1, 1, 'South Clevelandland', '3762 Mraz Underpass\nPort Carlosmouth, HI 65447-1583', '2025-05-29 11:23:00', '2025-05-29 11:23:00', NULL, NULL),
(2, 1, 'Donnieport', '38569 Eloisa View\nSouth Blake, SC 98161', '2025-05-29 11:23:00', '2025-05-29 11:23:00', NULL, NULL),
(3, 2, 'OceanBay', 'F8MM+XFG, Bakau', '2025-05-29 12:11:59', '2025-05-29 12:11:59', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `branch_delivery_settings`
--

CREATE TABLE `branch_delivery_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `max_radius` decimal(8,2) NOT NULL DEFAULT '5.00',
  `unit` enum('km','miles') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'km',
  `fee_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `fixed_fee` decimal(8,2) DEFAULT NULL,
  `per_distance_rate` decimal(8,2) DEFAULT NULL,
  `free_delivery_over_amount` decimal(8,2) DEFAULT NULL,
  `free_delivery_within_radius` double DEFAULT NULL,
  `delivery_schedule_start` time DEFAULT NULL,
  `delivery_schedule_end` time DEFAULT NULL,
  `prep_time_minutes` int(11) NOT NULL DEFAULT '20',
  `additional_eta_buffer_time` int(11) DEFAULT NULL,
  `avg_delivery_speed_kmh` int(11) NOT NULL DEFAULT '30',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cache`
--

CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `cache_locks`
--

CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `contacts`
--

CREATE TABLE `contacts` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `language_setting_id` bigint(20) UNSIGNED DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact_company` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `contacts`
--

INSERT INTO `contacts` (`id`, `language_setting_id`, `email`, `contact_company`, `image`, `address`, `created_at`, `updated_at`) VALUES
(1, 1, 'support@example.com', 'Bond Hobbs Inc', NULL, '957 Jamie Station, Lamontborough, SD 27319-9459', '2025-05-29 11:23:00', '2025-05-29 11:23:00');

-- --------------------------------------------------------

--
-- Table structure for table `countries`
--

CREATE TABLE `countries` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `countries_code` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phonecode` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `countries`
--

INSERT INTO `countries` (`id`, `countries_code`, `countries_name`, `phonecode`) VALUES
(1, 'AF', 'Afghanistan', '93'),
(2, 'AX', 'Åland Islands', '358'),
(3, 'AL', 'Albania', '355'),
(4, 'DZ', 'Algeria', '213'),
(5, 'AS', 'American Samoa', '1684'),
(6, 'AD', 'Andorra', '376'),
(7, 'AO', 'Angola', '244'),
(8, 'AI', 'Anguilla', '1264'),
(9, 'AQ', 'Antarctica', '0'),
(10, 'AG', 'Antigua and Barbuda', '1268'),
(11, 'AR', 'Argentina', '54'),
(12, 'AM', 'Armenia', '374'),
(13, 'AW', 'Aruba', '297'),
(14, 'AU', 'Australia', '61'),
(15, 'AT', 'Austria', '43'),
(16, 'AZ', 'Azerbaijan', '994'),
(17, 'BS', 'Bahamas', '1242'),
(18, 'BH', 'Bahrain', '973'),
(19, 'BD', 'Bangladesh', '880'),
(20, 'BB', 'Barbados', '1246'),
(21, 'BY', 'Belarus', '375'),
(22, 'BE', 'Belgium', '32'),
(23, 'BZ', 'Belize', '501'),
(24, 'BJ', 'Benin', '229'),
(25, 'BM', 'Bermuda', '1441'),
(26, 'BT', 'Bhutan', '975'),
(27, 'BO', 'Bolivia, Plurinational State of', '591'),
(28, 'BQ', 'Bonaire, Sint Eustatius and Saba', '599'),
(29, 'BA', 'Bosnia and Herzegovina', '387'),
(30, 'BW', 'Botswana', '267'),
(31, 'BV', 'Bouvet Island', '0'),
(32, 'BR', 'Brazil', '55'),
(33, 'IO', 'British Indian Ocean Territory', '246'),
(34, 'BN', 'Brunei Darussalam', '673'),
(35, 'BG', 'Bulgaria', '359'),
(36, 'BF', 'Burkina Faso', '226'),
(37, 'BI', 'Burundi', '257'),
(38, 'KH', 'Cambodia', '855'),
(39, 'CM', 'Cameroon', '237'),
(40, 'CA', 'Canada', '1'),
(41, 'CV', 'Cape Verde', '238'),
(42, 'KY', 'Cayman Islands', '1345'),
(43, 'CF', 'Central African Republic', '236'),
(44, 'TD', 'Chad', '235'),
(45, 'CL', 'Chile', '56'),
(46, 'CN', 'China', '86'),
(47, 'CX', 'Christmas Island', '61'),
(48, 'CC', 'Cocos (Keeling) Islands', '672'),
(49, 'CO', 'Colombia', '57'),
(50, 'KM', 'Comoros', '269'),
(51, 'CG', 'Congo', '242'),
(52, 'CD', 'Congo, the Democratic Republic of the', '242'),
(53, 'CK', 'Cook Islands', '682'),
(54, 'CR', 'Costa Rica', '506'),
(55, 'CI', 'Côte d\'Ivoire', '225'),
(56, 'HR', 'Croatia', '385'),
(57, 'CU', 'Cuba', '53'),
(58, 'CW', 'Curaçao', '599'),
(59, 'CY', 'Cyprus', '357'),
(60, 'CZ', 'Czech Republic', '420'),
(61, 'DK', 'Denmark', '45'),
(62, 'DJ', 'Djibouti', '253'),
(63, 'DM', 'Dominica', '1767'),
(64, 'DO', 'Dominican Republic', '1809'),
(65, 'EC', 'Ecuador', '593'),
(66, 'EG', 'Egypt', '20'),
(67, 'SV', 'El Salvador', '503'),
(68, 'GQ', 'Equatorial Guinea', '240'),
(69, 'ER', 'Eritrea', '291'),
(70, 'EE', 'Estonia', '372'),
(71, 'ET', 'Ethiopia', '251'),
(72, 'FK', 'Falkland Islands (Malvinas)', '500'),
(73, 'FO', 'Faroe Islands', '298'),
(74, 'FJ', 'Fiji', '679'),
(75, 'FI', 'Finland', '358'),
(76, 'FR', 'France', '33'),
(77, 'GF', 'French Guiana', '594'),
(78, 'PF', 'French Polynesia', '689'),
(79, 'TF', 'French Southern Territories', '0'),
(80, 'GA', 'Gabon', '241'),
(81, 'GM', 'Gambia', '220'),
(82, 'GE', 'Georgia', '995'),
(83, 'DE', 'Germany', '49'),
(84, 'GH', 'Ghana', '233'),
(85, 'GI', 'Gibraltar', '350'),
(86, 'GR', 'Greece', '30'),
(87, 'GL', 'Greenland', '299'),
(88, 'GD', 'Grenada', '1473'),
(89, 'GP', 'Guadeloupe', '590'),
(90, 'GU', 'Guam', '1671'),
(91, 'GT', 'Guatemala', '502'),
(92, 'GG', 'Guernsey', '44'),
(93, 'GN', 'Guinea', '224'),
(94, 'GW', 'Guinea-Bissau', '245'),
(95, 'GY', 'Guyana', '592'),
(96, 'HT', 'Haiti', '509'),
(97, 'HM', 'Heard Island and McDonald Islands', '0'),
(98, 'VA', 'Holy See (Vatican City State)', '39'),
(99, 'HN', 'Honduras', '504'),
(100, 'HK', 'Hong Kong', '852'),
(101, 'HU', 'Hungary', '36'),
(102, 'IS', 'Iceland', '354'),
(103, 'IN', 'India', '91'),
(104, 'ID', 'Indonesia', '62'),
(105, 'IR', 'Iran, Islamic Republic of', '98'),
(106, 'IQ', 'Iraq', '964'),
(107, 'IE', 'Ireland', '353'),
(108, 'IM', 'Isle of Man', '44'),
(109, 'IL', 'Israel', '972'),
(110, 'IT', 'Italy', '39'),
(111, 'JM', 'Jamaica', '1876'),
(112, 'JP', 'Japan', '81'),
(113, 'JE', 'Jersey', '44'),
(114, 'JO', 'Jordan', '962'),
(115, 'KZ', 'Kazakhstan', '7'),
(116, 'KE', 'Kenya', '254'),
(117, 'KI', 'Kiribati', '686'),
(118, 'KP', 'Korea, Democratic People\'s Republic of', '850'),
(119, 'KR', 'Korea, Republic of', '82'),
(120, 'KW', 'Kuwait', '965'),
(121, 'KG', 'Kyrgyzstan', '996'),
(122, 'LA', 'Lao People\'s Democratic Republic', '856'),
(123, 'LV', 'Latvia', '371'),
(124, 'LB', 'Lebanon', '961'),
(125, 'LS', 'Lesotho', '266'),
(126, 'LR', 'Liberia', '231'),
(127, 'LY', 'Libya', '218'),
(128, 'LI', 'Liechtenstein', '423'),
(129, 'LT', 'Lithuania', '370'),
(130, 'LU', 'Luxembourg', '352'),
(131, 'MO', 'Macao', '853'),
(132, 'MK', 'Macedonia, the Former Yugoslav Republic of', '389'),
(133, 'MG', 'Madagascar', '261'),
(134, 'MW', 'Malawi', '265'),
(135, 'MY', 'Malaysia', '60'),
(136, 'MV', 'Maldives', '960'),
(137, 'ML', 'Mali', '223'),
(138, 'MT', 'Malta', '356'),
(139, 'MH', 'Marshall Islands', '692'),
(140, 'MQ', 'Martinique', '596'),
(141, 'MR', 'Mauritania', '222'),
(142, 'MU', 'Mauritius', '230'),
(143, 'YT', 'Mayotte', '269'),
(144, 'MX', 'Mexico', '52'),
(145, 'FM', 'Micronesia, Federated States of', '691'),
(146, 'MD', 'Moldova, Republic of', '373'),
(147, 'MC', 'Monaco', '377'),
(148, 'MN', 'Mongolia', '976'),
(149, 'ME', 'Montenegro', '382'),
(150, 'MS', 'Montserrat', '1664'),
(151, 'MA', 'Morocco', '212'),
(152, 'MZ', 'Mozambique', '258'),
(153, 'MM', 'Myanmar', '95'),
(154, 'NA', 'Namibia', '264'),
(155, 'NR', 'Nauru', '674'),
(156, 'NP', 'Nepal', '977'),
(157, 'NL', 'Netherlands', '31'),
(158, 'NC', 'New Caledonia', '687'),
(159, 'NZ', 'New Zealand', '64'),
(160, 'NI', 'Nicaragua', '505'),
(161, 'NE', 'Niger', '227'),
(162, 'NG', 'Nigeria', '234'),
(163, 'NU', 'Niue', '683'),
(164, 'NF', 'Norfolk Island', '672'),
(165, 'MP', 'Northern Mariana Islands', '1670'),
(166, 'NO', 'Norway', '47'),
(167, 'OM', 'Oman', '968'),
(168, 'PK', 'Pakistan', '92'),
(169, 'PW', 'Palau', '680'),
(170, 'PS', 'Palestine, State of', '970'),
(171, 'PA', 'Panama', '507'),
(172, 'PG', 'Papua New Guinea', '675'),
(173, 'PY', 'Paraguay', '595'),
(174, 'PE', 'Peru', '51'),
(175, 'PH', 'Philippines', '63'),
(176, 'PN', 'Pitcairn', '0'),
(177, 'PL', 'Poland', '48'),
(178, 'PT', 'Portugal', '351'),
(179, 'PR', 'Puerto Rico', '1787'),
(180, 'QA', 'Qatar', '974'),
(181, 'RE', 'Réunion', '262'),
(182, 'RO', 'Romania', '40'),
(183, 'RU', 'Russian Federation', '7'),
(184, 'RW', 'Rwanda', '250'),
(185, 'BL', 'Saint Barthélemy', '590'),
(186, 'SH', 'Saint Helena, Ascension and Tristan da Cunha', '290'),
(187, 'KN', 'Saint Kitts and Nevis', '1869'),
(188, 'LC', 'Saint Lucia', '1758'),
(189, 'MF', 'Saint Martin (French part)', '590'),
(190, 'PM', 'Saint Pierre and Miquelon', '508'),
(191, 'VC', 'Saint Vincent and the Grenadines', '1784'),
(192, 'WS', 'Samoa', '684'),
(193, 'SM', 'San Marino', '378'),
(194, 'ST', 'Sao Tome and Principe', '239'),
(195, 'SA', 'Saudi Arabia', '966'),
(196, 'SN', 'Senegal', '221'),
(197, 'RS', 'Serbia', '381'),
(198, 'SC', 'Seychelles', '248'),
(199, 'SL', 'Sierra Leone', '232'),
(200, 'SG', 'Singapore', '65'),
(201, 'SX', 'Sint Maarten (Dutch part)', '1'),
(202, 'SK', 'Slovakia', '421'),
(203, 'SI', 'Slovenia', '386'),
(204, 'SB', 'Solomon Islands', '677'),
(205, 'SO', 'Somalia', '252'),
(206, 'ZA', 'South Africa', '27'),
(207, 'GS', 'South Georgia and the South Sandwich Islands', '0'),
(208, 'SS', 'South Sudan', '211'),
(209, 'ES', 'Spain', '34'),
(210, 'LK', 'Sri Lanka', '94'),
(211, 'SD', 'Sudan', '249'),
(212, 'SR', 'Suriname', '597'),
(213, 'SJ', 'Svalbard and Jan Mayen', '47'),
(214, 'SZ', 'Swaziland', '268'),
(215, 'SE', 'Sweden', '46'),
(216, 'CH', 'Switzerland', '41'),
(217, 'SY', 'Syrian Arab Republic', '963'),
(218, 'TW', 'Taiwan, Province of China', '886'),
(219, 'TJ', 'Tajikistan', '992'),
(220, 'TZ', 'Tanzania, United Republic of', '255'),
(221, 'TH', 'Thailand', '66'),
(222, 'TL', 'Timor-Leste', '670'),
(223, 'TG', 'Togo', '228'),
(224, 'TK', 'Tokelau', '690'),
(225, 'TO', 'Tonga', '676'),
(226, 'TT', 'Trinidad and Tobago', '1868'),
(227, 'TN', 'Tunisia', '216'),
(228, 'TR', 'Turkey', '90'),
(229, 'TM', 'Turkmenistan', '7370'),
(230, 'TC', 'Turks and Caicos Islands', '1649'),
(231, 'TV', 'Tuvalu', '688'),
(232, 'UG', 'Uganda', '256'),
(233, 'UA', 'Ukraine', '380'),
(234, 'AE', 'United Arab Emirates', '971'),
(235, 'GB', 'United Kingdom', '44'),
(236, 'US', 'United States', '1'),
(237, 'UM', 'United States Minor Outlying Islands', '1'),
(238, 'UY', 'Uruguay', '598'),
(239, 'UZ', 'Uzbekistan', '998'),
(240, 'VU', 'Vanuatu', '678'),
(241, 'VE', 'Venezuela, Bolivarian Republic of', '58'),
(242, 'VN', 'Viet Nam', '84'),
(243, 'VG', 'Virgin Islands, British', '1284'),
(244, 'VI', 'Virgin Islands, U.S.', '1340'),
(245, 'WF', 'Wallis and Futuna', '681'),
(246, 'EH', 'Western Sahara', '212'),
(247, 'YE', 'Yemen', '967'),
(248, 'ZM', 'Zambia', '260'),
(249, 'ZW', 'Zimbabwe', '263');

-- --------------------------------------------------------

--
-- Table structure for table `currencies`
--

CREATE TABLE `currencies` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `currency_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_symbol` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_position` enum('left','right','left_with_space','right_with_space') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'left',
  `no_of_decimal` int(10) UNSIGNED NOT NULL DEFAULT '2',
  `thousand_separator` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT ',',
  `decimal_separator` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '.',
  `exchange_rate` decimal(16,2) DEFAULT NULL,
  `usd_price` decimal(16,2) DEFAULT NULL,
  `is_cryptocurrency` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `currencies`
--

INSERT INTO `currencies` (`id`, `restaurant_id`, `currency_name`, `currency_code`, `currency_symbol`, `currency_position`, `no_of_decimal`, `thousand_separator`, `decimal_separator`, `exchange_rate`, `usd_price`, `is_cryptocurrency`) VALUES
(1, 1, 'Dollars', 'USD', '$', 'left', 2, ',', '.', NULL, NULL, 'no'),
(2, 1, 'Dalasi', 'GMD', 'D', 'left', 2, ',', '.', NULL, NULL, 'no'),
(3, 1, 'Pounds', 'GBP', '£', 'left', 2, ',', '.', NULL, NULL, 'no'),
(4, 1, 'Euros', 'EUR', '€', 'left', 2, ',', '.', NULL, NULL, 'no'),
(5, 2, 'Dollars', 'USD', '$', 'left', 2, ',', '.', NULL, NULL, 'no'),
(6, 2, 'Dalasis', 'GMD', 'D', 'left', 2, ',', '.', NULL, NULL, 'no'),
(7, 2, 'Pounds', 'GBP', '£', 'left', 2, ',', '.', NULL, NULL, 'no'),
(8, 2, 'Euros', 'EUR', '€', 'left', 2, ',', '.', NULL, NULL, 'no');

-- --------------------------------------------------------

--
-- Table structure for table `customers`
--

CREATE TABLE `customers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_otp` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `delivery_address` text COLLATE utf8mb4_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `customers`
--

INSERT INTO `customers` (`id`, `restaurant_id`, `name`, `phone`, `email`, `email_otp`, `created_at`, `updated_at`, `delivery_address`) VALUES
(1, 2, 'Breezy', '3146822', 'breezytestmail@gmail.com', NULL, '2025-05-29 14:58:40', '2025-05-29 14:58:40', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `customer_addresses`
--

CREATE TABLE `customer_addresses` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `customer_id` bigint(20) UNSIGNED DEFAULT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `lat` decimal(10,7) DEFAULT NULL,
  `lng` decimal(10,7) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `custom_menus`
--

CREATE TABLE `custom_menus` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `menu_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `menu_slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `menu_content` longtext COLLATE utf8mb4_unicode_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `delivery_executives`
--

CREATE TABLE `delivery_executives` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `photo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('available','on_delivery','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `delivery_fee_tiers`
--

CREATE TABLE `delivery_fee_tiers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `min_distance` double DEFAULT NULL,
  `max_distance` double DEFAULT NULL,
  `fee` decimal(8,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `email_settings`
--

CREATE TABLE `email_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `mail_from_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_from_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_queue` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `mail_driver` enum('mail','smtp') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'mail',
  `smtp_host` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_port` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `smtp_encryption` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_username` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mail_password` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `email_verified` tinyint(1) NOT NULL DEFAULT '0',
  `verified` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `email_settings`
--

INSERT INTO `email_settings` (`id`, `mail_from_name`, `mail_from_email`, `enable_queue`, `mail_driver`, `smtp_host`, `smtp_port`, `smtp_encryption`, `mail_username`, `mail_password`, `created_at`, `updated_at`, `email_verified`, `verified`) VALUES
(1, 'TableTrack', 'from@email.com', 'no', 'smtp', 'smtp.gmail.com', '465', 'ssl', 'myemail@gmail.com', NULL, '2025-05-29 11:23:00', '2025-05-29 11:23:00', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `expenses`
--

CREATE TABLE `expenses` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `expense_category_id` bigint(20) UNSIGNED DEFAULT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `expense_title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `amount` decimal(10,2) NOT NULL,
  `expense_date` date NOT NULL,
  `payment_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_due_date` date DEFAULT NULL,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt_path` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `expense_categories`
--

CREATE TABLE `expense_categories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `failed_jobs`
--

CREATE TABLE `failed_jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `file_storage`
--

CREATE TABLE `file_storage` (
  `id` int(10) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `path` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `filename` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `size` int(10) UNSIGNED NOT NULL,
  `storage_location` enum('local','aws_s3','digitalocean','wasabi','minio') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'local',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `file_storage`
--

INSERT INTO `file_storage` (`id`, `restaurant_id`, `path`, `filename`, `type`, `size`, `storage_location`, `created_at`, `updated_at`) VALUES
(1, 1, 'qrcodes', 'qrcode-branch-1-1.png', 'image/png', 2778, 'local', '2025-05-29 11:23:00', '2025-05-29 11:23:00'),
(2, 1, 'qrcodes', 'qrcode-branch-2-1.png', 'image/png', 2798, 'local', '2025-05-29 11:23:00', '2025-05-29 11:23:00'),
(3, NULL, 'logo', '71a5a044a938c5285769496f8c796eae.png', 'image/png', 94294, 'local', '2025-05-29 12:06:19', '2025-05-29 12:06:19'),
(4, NULL, 'favicons/super-admin/', 'android-chrome-192x192.png', 'image/png', 94294, 'local', '2025-05-29 12:06:19', '2025-05-29 12:06:19'),
(5, NULL, 'favicons/super-admin/', 'android-chrome-512x512.png', 'image/png', 94294, 'local', '2025-05-29 12:06:19', '2025-05-29 12:06:19'),
(6, NULL, 'favicons/super-admin/', 'apple-touch-icon.png', 'image/png', 94294, 'local', '2025-05-29 12:06:19', '2025-05-29 12:06:19'),
(7, NULL, 'favicons/super-admin/', 'favicon-16x16.png', 'image/png', 94294, 'local', '2025-05-29 12:06:19', '2025-05-29 12:06:19'),
(8, NULL, 'favicons/super-admin/', 'favicon-32x32.png', 'image/png', 94294, 'local', '2025-05-29 12:06:19', '2025-05-29 12:06:19'),
(9, NULL, 'favicons/super-admin/', 'favicon.ico', 'image/vnd.microsoft.icon', 51497, 'local', '2025-05-29 12:06:19', '2025-05-29 12:06:19'),
(10, 2, 'qrcodes', 'qrcode-branch-3-2.png', 'image/png', 2731, 'local', '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(11, NULL, 'profile-photos', '9cc02faa886fd017ee8e6287b25834da.png', 'image/png', 94294, 'local', '2025-05-29 12:14:36', '2025-05-29 12:14:36'),
(13, 2, 'item', 'aa08e86b5f865d18cfba0375a9e07727.jpg', 'image/jpeg', 78720, 'local', '2025-05-29 13:20:38', '2025-05-29 13:20:38'),
(14, 2, 'qrcodes', 'qrcode-3-t-1.png', 'image/png', 4752, 'local', '2025-05-29 13:30:47', '2025-05-29 13:30:47'),
(15, 2, 'profile-photos', 'c030c882c59d5e490a3817e946aaf880.png', 'image/png', 94294, 'local', '2025-05-29 14:30:30', '2025-05-29 14:30:30'),
(16, 2, 'qrcodes', 'qrcode-3-t-2.png', 'image/png', 5098, 'local', '2025-05-29 14:52:54', '2025-05-29 14:52:54'),
(17, 2, 'qrcodes', 'qrcode-3-t-3.png', 'image/png', 5024, 'local', '2025-05-29 14:53:14', '2025-05-29 14:53:14'),
(18, 2, 'qrcodes', 'qrcode-3-t-4.png', 'image/png', 4898, 'local', '2025-05-29 14:53:28', '2025-05-29 14:53:28'),
(19, 2, 'qrcodes', 'qrcode-3-t-5.png', 'image/png', 4940, 'local', '2025-05-29 14:53:40', '2025-05-29 14:53:40'),
(20, 2, 'qrcodes', 'qrcode-3-t-01.png', 'image/png', 5183, 'local', '2025-05-29 14:54:19', '2025-05-29 14:54:19'),
(21, 2, 'qrcodes', 'qrcode-3-t-02.png', 'image/png', 5421, 'local', '2025-05-29 14:54:39', '2025-05-29 14:54:39'),
(22, 2, 'qrcodes', 'qrcode-3-t-03.png', 'image/png', 5547, 'local', '2025-05-29 14:54:52', '2025-05-29 14:54:52'),
(23, 2, 'qrcodes', 'qrcode-3-t-04.png', 'image/png', 5366, 'local', '2025-05-29 14:55:07', '2025-05-29 14:55:07'),
(24, 2, 'item', 'cf4d941412321df84a1abd69ebfd92af.jpg', 'image/jpeg', 74873, 'local', '2025-05-29 15:06:05', '2025-05-29 15:06:05'),
(25, 2, 'item', 'aca3528e2b37199efae9530757d7eb4c.jpg', 'image/jpeg', 85703, 'local', '2025-05-29 15:07:25', '2025-05-29 15:07:25'),
(26, 2, 'item', '4abe7150b0abbf7cc18c4614eebeaa01.jpeg', 'image/jpeg', 17630, 'local', '2025-05-29 15:08:43', '2025-05-29 15:08:43'),
(27, 2, 'item', 'e82cc5a400ea04a08385b29e4541a05c.webp', 'image/webp', 33852, 'local', '2025-05-29 15:09:53', '2025-05-29 15:09:53'),
(28, 2, 'item', '417cbae466faffd39f0a5fa657f576d2.jpg', 'image/jpeg', 51266, 'local', '2025-05-29 15:11:15', '2025-05-29 15:11:15'),
(29, 2, 'item', '08952746ea2b455e25eaa1e03ca1d37c.jpg', 'image/jpeg', 392260, 'local', '2025-05-29 15:12:28', '2025-05-29 15:12:28'),
(30, 2, 'item', '8326fb16c4789ad208bcab86dadddbfa.jpg', 'image/jpeg', 79498, 'local', '2025-05-29 15:13:45', '2025-05-29 15:13:45'),
(31, 2, 'item', '2c834d958aa624f4bbbce2511d589f2b.jpg', 'image/jpeg', 104095, 'local', '2025-05-29 15:15:17', '2025-05-29 15:15:17'),
(32, 2, 'item', '3a74ebd08dd5062811ef3d193a672710.jpg', 'image/jpeg', 116021, 'local', '2025-05-29 15:16:17', '2025-05-29 15:16:17'),
(33, 2, 'item', '86238133edf6323defca06dd237d899a.jpg', 'image/jpeg', 337364, 'local', '2025-05-29 15:17:28', '2025-05-29 15:17:28');

-- --------------------------------------------------------

--
-- Table structure for table `file_storage_settings`
--

CREATE TABLE `file_storage_settings` (
  `id` int(10) UNSIGNED NOT NULL,
  `filesystem` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `auth_keys` text COLLATE utf8mb4_unicode_ci,
  `status` enum('enabled','disabled') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'disabled',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `file_storage_settings`
--

INSERT INTO `file_storage_settings` (`id`, `filesystem`, `auth_keys`, `status`, `created_at`, `updated_at`) VALUES
(1, 'local', NULL, 'enabled', '2025-05-29 11:22:56', '2025-05-29 11:22:56');

-- --------------------------------------------------------

--
-- Table structure for table `flags`
--

CREATE TABLE `flags` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `capital` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `continent` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `flags`
--

INSERT INTO `flags` (`id`, `capital`, `code`, `continent`, `name`) VALUES
(1, 'Kabul', 'af', 'Asia', 'Afghanistan'),
(2, 'Mariehamn', 'ax', 'Europe', 'Aland Islands'),
(3, 'Tirana', 'al', 'Europe', 'Albania'),
(4, 'Algiers', 'dz', 'Africa', 'Algeria'),
(5, 'Pago Pago', 'as', 'Oceania', 'American Samoa'),
(6, 'Andorra la Vella', 'ad', 'Europe', 'Andorra'),
(7, 'Luanda', 'ao', 'Africa', 'Angola'),
(8, 'The Valley', 'ai', 'North America', 'Anguilla'),
(9, '', 'aq', '', 'Antarctica'),
(10, 'St. John\'s', 'ag', 'North America', 'Antigua and Barbuda'),
(11, 'Buenos Aires', 'ar', 'South America', 'Argentina'),
(12, 'Yerevan', 'am', 'Asia', 'Armenia'),
(13, 'Oranjestad', 'aw', 'South America', 'Aruba'),
(14, 'Georgetown', 'ac', 'Africa', 'Ascension Island'),
(15, 'Canberra', 'au', 'Oceania', 'Australia'),
(16, 'Vienna', 'at', 'Europe', 'Austria'),
(17, 'Baku', 'az', 'Asia', 'Azerbaijan'),
(18, 'Nassau', 'bs', 'North America', 'Bahamas'),
(19, 'Manama', 'bh', 'Asia', 'Bahrain'),
(20, 'Dhaka', 'bd', 'Asia', 'Bangladesh'),
(21, 'Bridgetown', 'bb', 'North America', 'Barbados'),
(22, 'Minsk', 'by', 'Europe', 'Belarus'),
(23, 'Brussels', 'be', 'Europe', 'Belgium'),
(24, 'Belmopan', 'bz', 'North America', 'Belize'),
(25, 'Porto-Novo', 'bj', 'Africa', 'Benin'),
(26, 'Hamilton', 'bm', 'North America', 'Bermuda'),
(27, 'Thimphu', 'bt', 'Asia', 'Bhutan'),
(28, 'Sucre', 'bo', 'South America', 'Bolivia'),
(29, 'Kralendijk', 'bq', 'South America', 'Bonaire, Sint Eustatius and Saba'),
(30, 'Sarajevo', 'ba', 'Europe', 'Bosnia and Herzegovina'),
(31, 'Gaborone', 'bw', 'Africa', 'Botswana'),
(32, '', 'bv', '', 'Bouvet Island'),
(33, 'Brasília', 'br', 'South America', 'Brazil'),
(34, 'Diego Garcia', 'io', 'Asia', 'British Indian Ocean Territory'),
(35, 'Bandar Seri Begawan', 'bn', 'Asia', 'Brunei Darussalam'),
(36, 'Sofia', 'bg', 'Europe', 'Bulgaria'),
(37, 'Ouagadougou', 'bf', 'Africa', 'Burkina Faso'),
(38, 'Bujumbura', 'bi', 'Africa', 'Burundi'),
(39, 'Praia', 'cv', 'Africa', 'Cabo Verde'),
(40, 'Phnom Penh', 'kh', 'Asia', 'Cambodia'),
(41, 'Yaoundé', 'cm', 'Africa', 'Cameroon'),
(42, 'Ottawa', 'ca', 'North America', 'Canada'),
(43, '', 'ic', '', 'Canary Islands'),
(44, '', 'es-ct', '', 'Catalonia'),
(45, 'George Town', 'ky', 'North America', 'Cayman Islands'),
(46, 'Bangui', 'cf', 'Africa', 'Central African Republic'),
(47, '', 'cefta', '', 'Central European Free Trade Agreement'),
(48, '', 'ea', '', 'Ceuta & Melilla'),
(49, 'N\'Djamena', 'td', 'Africa', 'Chad'),
(50, 'Santiago', 'cl', 'South America', 'Chile'),
(51, 'Beijing', 'cn', 'Asia', 'China'),
(52, 'Flying Fish Cove', 'cx', 'Asia', 'Christmas Island'),
(53, '', 'cp', '', 'Clipperton Island'),
(54, 'West Island', 'cc', 'Asia', 'Cocos (Keeling) Islands'),
(55, 'Bogotá', 'co', 'South America', 'Colombia'),
(56, 'Moroni', 'km', 'Africa', 'Comoros'),
(57, 'Avarua', 'ck', 'Oceania', 'Cook Islands'),
(58, 'San José', 'cr', 'North America', 'Costa Rica'),
(59, 'Zagreb', 'hr', 'Europe', 'Croatia'),
(60, 'Havana', 'cu', 'North America', 'Cuba'),
(61, 'Willemstad', 'cw', 'South America', 'Curaçao'),
(62, 'Nicosia', 'cy', 'Europe', 'Cyprus'),
(63, 'Prague', 'cz', 'Europe', 'Czech Republic'),
(64, 'Yamoussoukro', 'ci', 'Africa', 'Côte d\'Ivoire'),
(65, 'Kinshasa', 'cd', 'Africa', 'Democratic Republic of the Congo'),
(66, 'Copenhagen', 'dk', 'Europe', 'Denmark'),
(67, '', 'dg', '', 'Diego Garcia'),
(68, 'Djibouti', 'dj', 'Africa', 'Djibouti'),
(69, 'Roseau', 'dm', 'North America', 'Dominica'),
(70, 'Santo Domingo', 'do', 'North America', 'Dominican Republic'),
(71, 'Quito', 'ec', 'South America', 'Ecuador'),
(72, 'Cairo', 'eg', 'Africa', 'Egypt'),
(73, 'San Salvador', 'sv', 'North America', 'El Salvador'),
(74, 'London', 'gb-eng', 'Europe', 'England'),
(75, 'Malabo', 'gq', 'Africa', 'Equatorial Guinea'),
(76, 'Asmara', 'er', 'Africa', 'Eritrea'),
(77, 'Tallinn', 'ee', 'Europe', 'Estonia'),
(78, 'Lobamba, Mbabane', 'sz', 'Africa', 'Eswatini'),
(79, 'Addis Ababa', 'et', 'Africa', 'Ethiopia'),
(80, '', 'eu', '', 'Europe'),
(81, 'Stanley', 'fk', 'South America', 'Falkland Islands'),
(82, 'Tórshavn', 'fo', 'Europe', 'Faroe Islands'),
(83, 'Palikir', 'fm', 'Oceania', 'Federated States of Micronesia'),
(84, 'Suva', 'fj', 'Oceania', 'Fiji'),
(85, 'Helsinki', 'fi', 'Europe', 'Finland'),
(86, 'Paris', 'fr', 'Europe', 'France'),
(87, 'Cayenne', 'gf', 'South America', 'French Guiana'),
(88, 'Papeete', 'pf', 'Oceania', 'French Polynesia'),
(89, 'Saint-Pierre, Réunion', 'tf', 'Africa', 'French Southern Territories'),
(90, 'Libreville', 'ga', 'Africa', 'Gabon'),
(91, '', 'es-ga', '', 'Galicia'),
(92, 'Banjul', 'gm', 'Africa', 'Gambia'),
(93, 'Tbilisi', 'ge', 'Asia', 'Georgia'),
(94, 'Berlin', 'de', 'Europe', 'Germany'),
(95, 'Accra', 'gh', 'Africa', 'Ghana'),
(96, 'Gibraltar', 'gi', 'Europe', 'Gibraltar'),
(97, 'Athens', 'gr', 'Europe', 'Greece'),
(98, 'Nuuk', 'gl', 'North America', 'Greenland'),
(99, 'St. George\'s', 'gd', 'North America', 'Grenada'),
(100, 'Basse-Terre', 'gp', 'North America', 'Guadeloupe'),
(101, 'Hagåtña', 'gu', 'Oceania', 'Guam'),
(102, 'Guatemala City', 'gt', 'North America', 'Guatemala'),
(103, 'Saint Peter Port', 'gg', 'Europe', 'Guernsey'),
(104, 'Conakry', 'gn', 'Africa', 'Guinea'),
(105, 'Bissau', 'gw', 'Africa', 'Guinea-Bissau'),
(106, 'Georgetown', 'gy', 'South America', 'Guyana'),
(107, 'Port-au-Prince', 'ht', 'North America', 'Haiti'),
(108, '', 'hm', '', 'Heard Island and McDonald Islands'),
(109, 'Vatican City', 'va', 'Europe', 'Holy See'),
(110, 'Tegucigalpa', 'hn', 'North America', 'Honduras'),
(111, 'Hong Kong', 'hk', 'Asia', 'Hong Kong'),
(112, 'Budapest', 'hu', 'Europe', 'Hungary'),
(113, 'Reykjavik', 'is', 'Europe', 'Iceland'),
(114, 'New Delhi', 'in', 'Asia', 'India'),
(115, 'Jakarta', 'id', 'Asia', 'Indonesia'),
(116, 'Tehran', 'ir', 'Asia', 'Iran'),
(117, 'Baghdad', 'iq', 'Asia', 'Iraq'),
(118, 'Dublin', 'ie', 'Europe', 'Ireland'),
(119, 'Douglas', 'im', 'Europe', 'Isle of Man'),
(120, 'Jerusalem', 'il', 'Asia', 'Israel'),
(121, 'Rome', 'it', 'Europe', 'Italy'),
(122, 'Kingston', 'jm', 'North America', 'Jamaica'),
(123, 'Tokyo', 'jp', 'Asia', 'Japan'),
(124, 'Saint Helier', 'je', 'Europe', 'Jersey'),
(125, 'Amman', 'jo', 'Asia', 'Jordan'),
(126, 'Astana', 'kz', 'Asia', 'Kazakhstan'),
(127, 'Nairobi', 'ke', 'Africa', 'Kenya'),
(128, 'South Tarawa', 'ki', 'Oceania', 'Kiribati'),
(129, 'Pristina', 'xk', 'Europe', 'Kosovo'),
(130, 'Kuwait City', 'kw', 'Asia', 'Kuwait'),
(131, 'Bishkek', 'kg', 'Asia', 'Kyrgyzstan'),
(132, 'Vientiane', 'la', 'Asia', 'Laos'),
(133, 'Riga', 'lv', 'Europe', 'Latvia'),
(134, 'Beirut', 'lb', 'Asia', 'Lebanon'),
(135, 'Maseru', 'ls', 'Africa', 'Lesotho'),
(136, 'Monrovia', 'lr', 'Africa', 'Liberia'),
(137, 'Tripoli', 'ly', 'Africa', 'Libya'),
(138, 'Vaduz', 'li', 'Europe', 'Liechtenstein'),
(139, 'Vilnius', 'lt', 'Europe', 'Lithuania'),
(140, 'Luxembourg City', 'lu', 'Europe', 'Luxembourg'),
(141, 'Macau', 'mo', 'Asia', 'Macau'),
(142, 'Antananarivo', 'mg', 'Africa', 'Madagascar'),
(143, 'Lilongwe', 'mw', 'Africa', 'Malawi'),
(144, 'Kuala Lumpur', 'my', 'Asia', 'Malaysia'),
(145, 'Malé', 'mv', 'Asia', 'Maldives'),
(146, 'Bamako', 'ml', 'Africa', 'Mali'),
(147, 'Valletta', 'mt', 'Europe', 'Malta'),
(148, 'Majuro', 'mh', 'Oceania', 'Marshall Islands'),
(149, 'Fort-de-France', 'mq', 'North America', 'Martinique'),
(150, 'Nouakchott', 'mr', 'Africa', 'Mauritania'),
(151, 'Port Louis', 'mu', 'Africa', 'Mauritius'),
(152, 'Mamoudzou', 'yt', 'Africa', 'Mayotte'),
(153, 'Mexico City', 'mx', 'North America', 'Mexico'),
(154, 'Chișinău', 'md', 'Europe', 'Moldova'),
(155, 'Monaco', 'mc', 'Europe', 'Monaco'),
(156, 'Ulaanbaatar', 'mn', 'Asia', 'Mongolia'),
(157, 'Podgorica', 'me', 'Europe', 'Montenegro'),
(158, 'Little Bay, Brades, Plymouth', 'ms', 'North America', 'Montserrat'),
(159, 'Rabat', 'ma', 'Africa', 'Morocco'),
(160, 'Maputo', 'mz', 'Africa', 'Mozambique'),
(161, 'Naypyidaw', 'mm', 'Asia', 'Myanmar'),
(162, 'Windhoek', 'na', 'Africa', 'Namibia'),
(163, 'Yaren District', 'nr', 'Oceania', 'Nauru'),
(164, 'Kathmandu', 'np', 'Asia', 'Nepal'),
(165, 'Amsterdam', 'nl', 'Europe', 'Netherlands'),
(166, 'Nouméa', 'nc', 'Oceania', 'New Caledonia'),
(167, 'Wellington', 'nz', 'Oceania', 'New Zealand'),
(168, 'Managua', 'ni', 'North America', 'Nicaragua'),
(169, 'Niamey', 'ne', 'Africa', 'Niger'),
(170, 'Abuja', 'ng', 'Africa', 'Nigeria'),
(171, 'Alofi', 'nu', 'Oceania', 'Niue'),
(172, 'Kingston', 'nf', 'Oceania', 'Norfolk Island'),
(173, 'Pyongyang', 'kp', 'Asia', 'North Korea'),
(174, 'Skopje', 'mk', 'Europe', 'North Macedonia'),
(175, 'Belfast', 'gb-nir', 'Europe', 'Northern Ireland'),
(176, 'Saipan', 'mp', 'Oceania', 'Northern Mariana Islands'),
(177, 'Oslo', 'no', 'Europe', 'Norway'),
(178, 'Muscat', 'om', 'Asia', 'Oman'),
(179, 'Islamabad', 'pk', 'Asia', 'Pakistan'),
(180, 'Ngerulmud', 'pw', 'Oceania', 'Palau'),
(181, 'Panama City', 'pa', 'North America', 'Panama'),
(182, 'Port Moresby', 'pg', 'Oceania', 'Papua New Guinea'),
(183, 'Asunción', 'py', 'South America', 'Paraguay'),
(184, 'Lima', 'pe', 'South America', 'Peru'),
(185, 'Manila', 'ph', 'Asia', 'Philippines'),
(186, 'Adamstown', 'pn', 'Oceania', 'Pitcairn'),
(187, 'Warsaw', 'pl', 'Europe', 'Poland'),
(188, 'Lisbon', 'pt', 'Europe', 'Portugal'),
(189, 'San Juan', 'pr', 'North America', 'Puerto Rico'),
(190, 'Doha', 'qa', 'Asia', 'Qatar'),
(191, 'Brazzaville', 'cg', 'Africa', 'Republic of the Congo'),
(192, 'Bucharest', 'ro', 'Europe', 'Romania'),
(193, 'Moscow', 'ru', 'Europe', 'Russia'),
(194, 'Kigali', 'rw', 'Africa', 'Rwanda'),
(195, 'Saint-Denis', 're', 'Africa', 'Réunion'),
(196, 'Gustavia', 'bl', 'North America', 'Saint Barthélemy'),
(197, 'Jamestown', 'sh', 'Africa', 'Saint Helena, Ascension and Tristan da Cunha'),
(198, 'Basseterre', 'kn', 'North America', 'Saint Kitts and Nevis'),
(199, 'Castries', 'lc', 'North America', 'Saint Lucia'),
(200, 'Marigot', 'mf', 'North America', 'Saint Martin'),
(201, 'Saint-Pierre', 'pm', 'North America', 'Saint Pierre and Miquelon'),
(202, 'Kingstown', 'vc', 'North America', 'Saint Vincent and the Grenadines'),
(203, 'Apia', 'ws', 'Oceania', 'Samoa'),
(204, 'San Marino', 'sm', 'Europe', 'San Marino'),
(205, 'São Tomé', 'st', 'Africa', 'Sao Tome and Principe'),
(206, 'Riyadh', 'sa', 'Asia', 'Saudi Arabia'),
(207, 'Edinburgh', 'gb-sct', 'Europe', 'Scotland'),
(208, 'Dakar', 'sn', 'Africa', 'Senegal'),
(209, 'Belgrade', 'rs', 'Europe', 'Serbia'),
(210, 'Victoria', 'sc', 'Africa', 'Seychelles'),
(211, 'Freetown', 'sl', 'Africa', 'Sierra Leone'),
(212, 'Singapore', 'sg', 'Asia', 'Singapore'),
(213, 'Philipsburg', 'sx', 'North America', 'Sint Maarten'),
(214, 'Bratislava', 'sk', 'Europe', 'Slovakia'),
(215, 'Ljubljana', 'si', 'Europe', 'Slovenia'),
(216, 'Honiara', 'sb', 'Oceania', 'Solomon Islands'),
(217, 'Mogadishu', 'so', 'Africa', 'Somalia'),
(218, 'Pretoria', 'za', 'Africa', 'South Africa'),
(219, 'King Edward Point', 'gs', 'Antarctica', 'South Georgia and the South Sandwich Islands'),
(220, 'Seoul', 'kr', 'Asia', 'South Korea'),
(221, 'Juba', 'ss', 'Africa', 'South Sudan'),
(222, 'Madrid', 'es', 'Europe', 'Spain'),
(223, 'Sri Jayawardenepura Kotte, Colombo', 'lk', 'Asia', 'Sri Lanka'),
(224, 'Ramallah', 'ps', 'Asia', 'State of Palestine'),
(225, 'Khartoum', 'sd', 'Africa', 'Sudan'),
(226, 'Paramaribo', 'sr', 'South America', 'Suriname'),
(227, 'Longyearbyen', 'sj', 'Europe', 'Svalbard and Jan Mayen'),
(228, 'Stockholm', 'se', 'Europe', 'Sweden'),
(229, 'Bern', 'ch', 'Europe', 'Switzerland'),
(230, 'Damascus', 'sy', 'Asia', 'Syria'),
(231, 'Taipei', 'tw', 'Asia', 'Taiwan'),
(232, 'Dushanbe', 'tj', 'Asia', 'Tajikistan'),
(233, 'Dodoma', 'tz', 'Africa', 'Tanzania'),
(234, 'Bangkok', 'th', 'Asia', 'Thailand'),
(235, 'Dili', 'tl', 'Asia', 'Timor-Leste'),
(236, 'Lomé', 'tg', 'Africa', 'Togo'),
(237, 'Nukunonu, Atafu,Tokelau', 'tk', 'Oceania', 'Tokelau'),
(238, 'Nukuʻalofa', 'to', 'Oceania', 'Tonga'),
(239, 'Port of Spain', 'tt', 'South America', 'Trinidad and Tobago'),
(240, '', 'ta', '', 'Tristan da Cunha'),
(241, 'Tunis', 'tn', 'Africa', 'Tunisia'),
(242, 'Ankara', 'tr', 'Asia', 'Turkey'),
(243, 'Ashgabat', 'tm', 'Asia', 'Turkmenistan'),
(244, 'Cockburn Town', 'tc', 'North America', 'Turks and Caicos Islands'),
(245, 'Funafuti', 'tv', 'Oceania', 'Tuvalu'),
(246, 'Kampala', 'ug', 'Africa', 'Uganda'),
(247, 'Kiev', 'ua', 'Europe', 'Ukraine'),
(248, 'Abu Dhabi', 'ae', 'Asia', 'United Arab Emirates'),
(249, 'London', 'gb', 'Europe', 'United Kingdom'),
(250, '', 'un', '', 'United Nations'),
(251, 'Washington, D.C.', 'um', 'North America', 'United States Minor Outlying Islands'),
(252, 'Washington, D.C.', 'us', 'North America', 'United States of America'),
(253, '', 'xx', '', 'Unknown'),
(254, 'Montevideo', 'uy', 'South America', 'Uruguay'),
(255, 'Tashkent', 'uz', 'Asia', 'Uzbekistan'),
(256, 'Port Vila', 'vu', 'Oceania', 'Vanuatu'),
(257, 'Caracas', 've', 'South America', 'Venezuela'),
(258, 'Hanoi', 'vn', 'Asia', 'Vietnam'),
(259, 'Road Town', 'vg', 'North America', 'Virgin Islands (British)'),
(260, 'Charlotte Amalie', 'vi', 'North America', 'Virgin Islands (U.S.)'),
(261, 'Cardiff', 'gb-wls', 'Europe', 'Wales'),
(262, 'Mata-Utu', 'wf', 'Oceania', 'Wallis and Futuna'),
(263, 'Laayoune', 'eh', 'Africa', 'Western Sahara'),
(264, 'Sana\'a', 'ye', 'Asia', 'Yemen'),
(265, 'Lusaka', 'zm', 'Africa', 'Zambia'),
(266, 'Harare', 'zw', 'Africa', 'Zimbabwe');

-- --------------------------------------------------------

--
-- Table structure for table `flutterwave_payments`
--

CREATE TABLE `flutterwave_payments` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `flutterwave_payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` bigint(20) UNSIGNED NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `payment_status` enum('pending','completed','failed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `payment_date` timestamp NULL DEFAULT NULL,
  `payment_error_response` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `front_details`
--

CREATE TABLE `front_details` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `language_setting_id` bigint(20) UNSIGNED DEFAULT NULL,
  `header_title` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `header_description` text COLLATE utf8mb4_unicode_ci,
  `image` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `feature_with_image_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `review_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `feature_with_icon_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comments_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `faq_heading` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `faq_description` text COLLATE utf8mb4_unicode_ci,
  `contact_heading` text COLLATE utf8mb4_unicode_ci,
  `footer_copyright_text` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `front_details`
--

INSERT INTO `front_details` (`id`, `language_setting_id`, `header_title`, `header_description`, `image`, `feature_with_image_heading`, `review_heading`, `feature_with_icon_heading`, `comments_heading`, `price_heading`, `price_description`, `faq_heading`, `faq_description`, `contact_heading`, `footer_copyright_text`, `created_at`, `updated_at`) VALUES
(1, 1, 'Restaurant POS software made simple!', 'Easily manage orders, menus, and tables in one place. Save time, reduce errors, and grow your business faster', NULL, 'Take Control of Your Restaurant', 'What Restaurant Owners Are Saying', 'Powerful Features Built to Elevate Your Restaurant Operations', NULL, 'Simple, Transparent Pricing', 'Get everything you need to manage your restaurant with one affordable plan.', 'Your questions, answered', 'Answers to the most frequently asked questions.', 'Contact', '© 2025 TableTrack. All Rights Reserved.', '2025-05-29 11:23:00', '2025-05-29 11:23:00');

-- --------------------------------------------------------

--
-- Table structure for table `front_faq_settings`
--

CREATE TABLE `front_faq_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `language_setting_id` bigint(20) UNSIGNED DEFAULT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `front_faq_settings`
--

INSERT INTO `front_faq_settings` (`id`, `language_setting_id`, `question`, `answer`, `created_at`, `updated_at`) VALUES
(1, 1, 'How can I contact customer support 1?', 'Our dedicated support team is available via email to assist you with any questions or technical issues.', NULL, NULL),
(2, 1, 'How can I contact customer support?', 'Our dedicated support team is available via email to assist you with any questions or technical issues.', NULL, NULL),
(3, 1, 'How can I contact customer support?', 'Our dedicated support team is available via email to assist you with any questions or technical issues.', NULL, NULL),
(4, 1, 'How can I contact customer support?', 'Our dedicated support team is available via email to assist you with any questions or technical issues.', NULL, NULL),
(5, 1, 'How can I contact customer support?', 'Our dedicated support team is available via email to assist you with any questions or technical issues.', NULL, NULL),
(6, 1, 'How can I contact customer support?', 'Our dedicated support team is available via email to assist you with any questions or technical issues.', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `front_features`
--

CREATE TABLE `front_features` (
  `id` int(10) UNSIGNED NOT NULL,
  `language_setting_id` bigint(20) UNSIGNED DEFAULT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `image` longtext COLLATE utf8mb4_unicode_ci,
  `icon` longtext COLLATE utf8mb4_unicode_ci,
  `type` enum('image','icon','task','bills','team','apps') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'image',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `front_features`
--

INSERT INTO `front_features` (`id`, `language_setting_id`, `title`, `description`, `image`, `icon`, `type`, `created_at`, `updated_at`) VALUES
(1, 1, 'Streamline Order Management', 'Never lose track of an order again. All your customer orders—from dine-in to takeout—are organized and easily accessible in one place.\n                                Speed up service and keep your kitchen running smoothly.', NULL, NULL, 'image', NULL, NULL),
(2, 1, 'Optimize Table Reservations', 'Maximize seating efficiency with real-time table tracking and reservations. Reduce wait times and ensure no table sits empty during peak hours, improving customer experience and turnover.', NULL, NULL, 'image', NULL, NULL),
(3, 1, 'Effortless Menu Management', 'Easily add, edit, or remove items from your menu on the go. Highlight specials, update prices, and keep everything in sync across all platforms, so your staff and customers always see the latest offerings.', NULL, NULL, 'image', NULL, NULL),
(4, 1, 'QR Code Menu', 'Contactless Ordering Made Easy', NULL, '<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\" class=\"bi bi-qr-code-scan text-skin-base dark:text-skin-base size-6\" viewBox=\"0 0 16 16\"><path d=\"M0 .5A.5.5 0 0 1 .5 0h3a.5.5 0 0 1 0 1H1v2.5a.5.5 0 0 1-1 0zm12 0a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0V1h-2.5a.5.5 0 0 1-.5-.5M.5 12a.5.5 0 0 1 .5.5V15h2.5a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 .5-.5m15 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1 0-1H15v-2.5a.5.5 0 0 1 .5-.5M4 4h1v1H4z\" /><path d=\"M7 2H2v5h5zM3 3h3v3H3zm2 8H4v1h1z\" /><path d=\"M7 9H2v5h5zm-4 1h3v3H3zm8-6h1v1h-1z\" /><path d=\"M9 2h5v5H9zm1 1v3h3V3zM8 8v2h1v1H8v1h2v-2h1v2h1v-1h2v-1h-3V8zm2 2H9V9h1zm4 2h-1v1h-2v1h3zm-4 2v-1H8v1z\" /><path d=\"M12 9h2V8h-2z\" /></svg>', 'icon', NULL, NULL),
(5, 1, 'Payment Gateway Integration', 'Fast, Secure, and Flexible Payments using Stripe and Razorpay', NULL, '<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\"\n                        class=\"bi bi-qr-code-scan text-skin-base dark:text-skin-base size-6\" viewBox=\"0 0 16 16\">\n                        <path\n                            d=\"M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm6.226 5.385c-.584 0-.937.164-.937.593 0 .468.607.674 1.36.93 1.228.415 2.844.963 2.851 2.993C11.5 11.868 9.924 13 7.63 13a7.7 7.7 0 0 1-3.009-.626V9.758c.926.506 2.095.88 3.01.88.617 0 1.058-.165 1.058-.671 0-.518-.658-.755-1.453-1.041C6.026 8.49 4.5 7.94 4.5 6.11 4.5 4.165 5.988 3 8.226 3a7.3 7.3 0 0 1 2.734.505v2.583c-.838-.45-1.896-.703-2.734-.703\" />\n                    </svg>', 'icon', NULL, NULL),
(6, 1, 'Staff Management', 'Separate login for every staff role with different permissions.', NULL, '<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\"\n                        class=\"bi bi-qr-code-scan text-skin-base dark:text-skin-base size-6\" viewBox=\"0 0 16 16\">\n                        <path\n                            d=\"M15 14s1 0 1-1-1-4-5-4-5 3-5 4 1 1 1 1zm-7.978-1L7 12.996c.001-.264.167-1.03.76-1.72C8.312 10.629 9.282 10 11 10c1.717 0 2.687.63 3.24 1.276.593.69.758 1.457.76 1.72l-.008.002-.014.002zM11 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4m3-2a3 3 0 1 1-6 0 3 3 0 0 1 6 0M6.936 9.28a6 6 0 0 0-1.23-.247A7 7 0 0 0 5 9c-4 0-5 3-5 4q0 1 1 1h4.216A2.24 2.24 0 0 1 5 13c0-1.01.377-2.042 1.09-2.904.243-.294.526-.569.846-.816M4.92 10A5.5 5.5 0 0 0 4 13H1c0-.26.164-1.03.76-1.724.545-.636 1.492-1.256 3.16-1.275ZM1.5 5.5a3 3 0 1 1 6 0 3 3 0 0 1-6 0m3-2a2 2 0 1 0 0 4 2 2 0 0 0 0-4\" />\n                    </svg>', 'icon', NULL, NULL),
(7, 1, 'POS (Point of Sale)', 'Complete POS Integration', NULL, '<svg class=\"size-6 transition duration-75 text-skin-base dark:text-skin-base\" fill=\"currentColor\"\n                        viewBox=\"0 -0.5 25 25\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\">\n                        <g id=\"SVGRepo_bgCarrier\" stroke-width=\"0\"></g>\n                        <g id=\"SVGRepo_tracerCarrier\" stroke-linecap=\"round\" stroke-linejoin=\"round\"></g>\n                        <g id=\"SVGRepo_iconCarrier\">\n                            <path fill-rule=\"evenodd\"\n                                d=\"M16,6 L20,6 C21.1045695,6 22,6.8954305 22,8 L22,16 C22,17.1045695 21.1045695,18 20,18 L16,18 L16,19.9411765 C16,21.0658573 15.1177541,22 14,22 L4,22 C2.88224586,22 2,21.0658573 2,19.9411765 L2,4.05882353 C2,2.93414267 2.88224586,2 4,2 L14,2 C15.1177541,2 16,2.93414267 16,4.05882353 L16,6 Z M20,11 L16,11 L16,16 L20,16 L20,11 Z M14,19.9411765 L14,4.05882353 C14,4.01396021 13.9868154,4 14,4 L4,4 C4.01318464,4 4,4.01396021 4,4.05882353 L4,19.9411765 C4,19.9860398 4.01318464,20 4,20 L14,20 C13.9868154,20 14,19.9860398 14,19.9411765 Z M5,19 L5,17 L7,17 L7,19 L5,19 Z M8,19 L8,17 L10,17 L10,19 L8,19 Z M11,19 L11,17 L13,17 L13,19 L11,19 Z M5,16 L5,14 L7,14 L7,16 L5,16 Z M8,16 L8,14 L10,14 L10,16 L8,16 Z M11,16 L11,14 L13,14 L13,16 L11,16 Z M13,5 L13,13 L5,13 L5,5 L13,5 Z M7,7 L7,11 L11,11 L11,7 L7,7 Z M20,9 L20,8 L16,8 L16,9 L20,9 Z\">\n                            </path>\n                        </g>\n                    </svg>', 'icon', NULL, NULL),
(8, 1, 'Custom Floor Plans', 'Design Your Restaurants Layout.', NULL, '<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\"\n                        class=\"bi bi-qr-code-scan text-skin-base dark:text-skin-base size-6\" viewBox=\"0 0 16 16\">\n                        <path\n                            d=\"M8.235 1.559a.5.5 0 0 0-.47 0l-7.5 4a.5.5 0 0 0 0 .882L3.188 8 .264 9.559a.5.5 0 0 0 0 .882l7.5 4a.5.5 0 0 0 .47 0l7.5-4a.5.5 0 0 0 0-.882L12.813 8l2.922-1.559a.5.5 0 0 0 0-.882zm3.515 7.008L14.438 10 8 13.433 1.562 10 4.25 8.567l3.515 1.874a.5.5 0 0 0 .47 0zM8 9.433 1.562 6 8 2.567 14.438 6z\" />\n                    </svg>', 'icon', NULL, NULL),
(9, 1, 'Kitchen Order Tickets (KOT)', 'Efficient Kitchen Workflow.', NULL, '<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\"\n                        class=\"bi bi-qr-code-scan text-skin-base dark:text-skin-base size-6\" viewBox=\"0 0 16 16\">\n                        <path\n                            d=\"M3 4.5a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 1 1 0 1h-6a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5m0 2a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5M11.5 4a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1zm0 2a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1zm0 2a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1zm0 2a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1zm0 2a.5.5 0 0 0 0 1h1a.5.5 0 0 0 0-1z\" />\n                        <path\n                            d=\"M2.354.646a.5.5 0 0 0-.801.13l-.5 1A.5.5 0 0 0 1 2v13H.5a.5.5 0 0 0 0 1h15a.5.5 0 0 0 0-1H15V2a.5.5 0 0 0-.053-.224l-.5-1a.5.5 0 0 0-.8-.13L13 1.293l-.646-.647a.5.5 0 0 0-.708 0L11 1.293l-.646-.647a.5.5 0 0 0-.708 0L9 1.293 8.354.646a.5.5 0 0 0-.708 0L7 1.293 6.354.646a.5.5 0 0 0-.708 0L5 1.293 4.354.646a.5.5 0 0 0-.708 0L3 1.293zm-.217 1.198.51.51a.5.5 0 0 0 .707 0L4 1.707l.646.647a.5.5 0 0 0 .708 0L6 1.707l.646.647a.5.5 0 0 0 .708 0L8 1.707l.646.647a.5.5 0 0 0 .708 0L10 1.707l.646.647a.5.5 0 0 0 .708 0L12 1.707l.646.647a.5.5 0 0 0 .708 0l.509-.51.137.274V15H2V2.118z\" />\n                    </svg>', 'icon', NULL, NULL),
(10, 1, 'Bill Printing', 'Quick and Accurate Billing.', NULL, '<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\"\n                        class=\"bi bi-qr-code-scan text-skin-base dark:text-skin-base size-6\" viewBox=\"0 0 16 16\">\n                        <path d=\"M2.5 8a.5.5 0 1 0 0-1 .5.5 0 0 0 0 1\" />\n                        <path\n                            d=\"M5 1a2 2 0 0 0-2 2v2H2a2 2 0 0 0-2 2v3a2 2 0 0 0 2 2h1v1a2 2 0 0 0 2 2h6a2 2 0 0 0 2-2v-1h1a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2h-1V3a2 2 0 0 0-2-2zM4 3a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1v2H4zm1 5a2 2 0 0 0-2 2v1H2a1 1 0 0 1-1-1V7a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1h-1v-1a2 2 0 0 0-2-2zm7 2v3a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-3a1 1 0 0 1 1-1h6a1 1 0 0 1 1 1\" />\n                    </svg>', 'icon', NULL, NULL),
(11, 1, 'Reports', 'Data-Driven Decisions.', NULL, '<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"currentColor\"\n                        class=\"bi bi-qr-code-scan text-skin-base dark:text-skin-base size-6\" viewBox=\"0 0 16 16\">\n                        <path fill-rule=\"evenodd\"\n                            d=\"M0 0h1v15h15v1H0zm10 3.5a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 .5.5v4a.5.5 0 0 1-1 0V4.9l-3.613 4.417a.5.5 0 0 1-.74.037L7.06 6.767l-3.656 5.027a.5.5 0 0 1-.808-.588l4-5.5a.5.5 0 0 1 .758-.06l2.609 2.61L13.445 4H10.5a.5.5 0 0 1-.5-.5\" />\n                    </svg>', 'icon', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `front_review_settings`
--

CREATE TABLE `front_review_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `language_setting_id` bigint(20) UNSIGNED DEFAULT NULL,
  `reviews` text COLLATE utf8mb4_unicode_ci,
  `reviewer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reviewer_designation` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `front_review_settings`
--

INSERT INTO `front_review_settings` (`id`, `language_setting_id`, `reviews`, `reviewer_name`, `reviewer_designation`, `created_at`, `updated_at`) VALUES
(1, 1, '\" It has completely transformed how we operate. Managing orders, tables, and staff all from one platform has reduced our workload and made everything run more smoothly. \"', 'John Martin', 'Owner of Riverbend Bistro', NULL, NULL),
(2, 1, '\" The QR Code menu and payment integration have made a huge difference for us, especially after the pandemic. Customers love the ease, and we’ve seen faster table turnover.\"', 'Emily Thompson', 'Manager at Lakeside Grill', NULL, NULL),
(3, 1, '\" We are able to track every order in real time, keep our menu updated, and quickly manage payments. It is like having an extra set of hands in the restaurant.\"', 'Michael Scott', 'Owner of Downtown Eats', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `global_currencies`
--

CREATE TABLE `global_currencies` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `currency_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_symbol` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `currency_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `exchange_rate` decimal(16,2) DEFAULT NULL,
  `usd_price` decimal(16,2) DEFAULT NULL,
  `is_cryptocurrency` enum('yes','no') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `currency_position` enum('left','right','left_with_space','right_with_space') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'left',
  `no_of_decimal` int(10) UNSIGNED NOT NULL DEFAULT '2',
  `thousand_separator` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `decimal_separator` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('enable','disable') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'enable',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `global_currencies`
--

INSERT INTO `global_currencies` (`id`, `currency_name`, `currency_symbol`, `currency_code`, `exchange_rate`, `usd_price`, `is_cryptocurrency`, `currency_position`, `no_of_decimal`, `thousand_separator`, `decimal_separator`, `status`, `created_at`, `updated_at`, `deleted_at`) VALUES
(1, 'Dollars', '$', 'USD', NULL, NULL, 'no', 'left', 2, ',', '.', 'enable', '2025-05-29 11:22:54', '2025-05-29 11:22:54', NULL),
(2, 'Rupee', '₹', 'INR', NULL, NULL, 'no', 'left', 2, ',', '.', 'enable', '2025-05-29 11:22:54', '2025-05-29 11:22:54', NULL),
(3, 'Pounds', '£', 'GBP', NULL, NULL, 'no', 'left', 2, ',', '.', 'enable', '2025-05-29 11:22:54', '2025-05-29 11:22:54', NULL),
(4, 'Euros', '€', 'EUR', NULL, NULL, 'no', 'left', 2, ',', '.', 'enable', '2025-05-29 11:22:54', '2025-05-29 11:22:54', NULL),
(5, 'Dalasi', 'D', 'GMD', NULL, NULL, 'no', 'left', 2, ',', '.', 'enable', '2025-05-29 14:43:40', '2025-05-29 14:46:03', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `global_invoices`
--

CREATE TABLE `global_invoices` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `currency_id` bigint(20) UNSIGNED DEFAULT NULL,
  `package_id` bigint(20) UNSIGNED DEFAULT NULL,
  `global_subscription_id` bigint(20) UNSIGNED DEFAULT NULL,
  `offline_method_id` bigint(20) UNSIGNED DEFAULT NULL,
  `signature` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `package_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` int(11) DEFAULT NULL,
  `total` int(11) DEFAULT NULL,
  `billing_frequency` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_interval` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `recurring` enum('yes','no') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscription_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(16,2) DEFAULT NULL,
  `stripe_invoice_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pay_date` datetime DEFAULT NULL,
  `next_pay_date` datetime DEFAULT NULL,
  `gateway_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `global_invoices`
--

INSERT INTO `global_invoices` (`id`, `restaurant_id`, `currency_id`, `package_id`, `global_subscription_id`, `offline_method_id`, `signature`, `token`, `transaction_id`, `package_type`, `sub_total`, `total`, `billing_frequency`, `billing_interval`, `recurring`, `plan_id`, `subscription_id`, `invoice_id`, `amount`, `stripe_invoice_number`, `pay_date`, `next_pay_date`, `gateway_name`, `status`, `created_at`, `updated_at`) VALUES
(1, 1, 1, 5, 1, NULL, NULL, NULL, 'MUJRWLIQDSKZPQC', 'trial', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-05-29 11:23:00', '2025-06-28 11:23:00', 'offline', 'active', '2025-05-29 11:23:00', '2025-05-29 11:23:00'),
(2, 2, 1, 5, 2, NULL, NULL, NULL, 'Y6QNIBAICE8BOXU', 'trial', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-05-29 12:11:59', '2025-06-28 12:11:59', 'offline', 'active', '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(3, 2, 1, 5, 3, NULL, NULL, NULL, 'ADTEYT8EDUEGL0X', 'free', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-05-29 00:00:00', NULL, 'offline', NULL, '2025-05-29 12:13:31', '2025-05-29 12:13:31'),
(4, 1, 1, 1, 4, NULL, NULL, NULL, 'KLMUR92BUPHTY0L', 'monthly', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2025-06-28 00:00:06', '2025-07-28 00:00:00', 'offline', NULL, '2025-06-28 00:00:06', '2025-06-28 00:00:06');

-- --------------------------------------------------------

--
-- Table structure for table `global_settings`
--

CREATE TABLE `global_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `purchase_code` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `supported_until` timestamp NULL DEFAULT NULL,
  `last_license_verified_at` timestamp NULL DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `theme_hex` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `theme_rgb` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locale` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `license_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hide_cron_job` tinyint(1) NOT NULL DEFAULT '0',
  `last_cron_run` timestamp NULL DEFAULT NULL,
  `system_update` tinyint(1) NOT NULL DEFAULT '1',
  `purchased_on` timestamp NULL DEFAULT NULL,
  `timezone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Asia/Kolkata',
  `disable_landing_site` tinyint(1) NOT NULL DEFAULT '0',
  `landing_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'static',
  `landing_site_type` enum('theme','custom') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'theme',
  `landing_site_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `installed_url` tinytext COLLATE utf8mb4_unicode_ci,
  `requires_approval_after_signup` tinyint(1) NOT NULL DEFAULT '0',
  `facebook_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `instagram_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `yelp_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_currency_id` bigint(20) UNSIGNED DEFAULT NULL,
  `show_logo_text` tinyint(1) NOT NULL DEFAULT '1',
  `meta_title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_keyword` text COLLATE utf8mb4_unicode_ci,
  `meta_description` longtext COLLATE utf8mb4_unicode_ci,
  `upload_fav_icon_android_chrome_192` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upload_fav_icon_android_chrome_512` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upload_fav_icon_apple_touch_icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upload_favicon_16` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upload_favicon_32` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `favicon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `webmanifest` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_pwa_install_alert_show` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `global_settings`
--

INSERT INTO `global_settings` (`id`, `purchase_code`, `supported_until`, `last_license_verified_at`, `email`, `created_at`, `updated_at`, `name`, `logo`, `theme_hex`, `theme_rgb`, `locale`, `license_type`, `hide_cron_job`, `last_cron_run`, `system_update`, `purchased_on`, `timezone`, `disable_landing_site`, `landing_type`, `landing_site_type`, `landing_site_url`, `installed_url`, `requires_approval_after_signup`, `facebook_link`, `instagram_link`, `twitter_link`, `yelp_link`, `default_currency_id`, `show_logo_text`, `meta_title`, `meta_keyword`, `meta_description`, `upload_fav_icon_android_chrome_192`, `upload_fav_icon_android_chrome_512`, `upload_fav_icon_apple_touch_icon`, `upload_favicon_16`, `upload_favicon_32`, `favicon`, `hash`, `webmanifest`, `is_pwa_install_alert_show`) VALUES
(1, NULL, NULL, NULL, NULL, '2025-05-29 11:23:00', '2025-08-05 05:25:03', 'OceanBay Menu Scanner', '71a5a044a938c5285769496f8c796eae.png', '#F97316', '249, 115, 22', 'en', NULL, 1, '2025-08-05 05:25:03', 1, NULL, 'Asia/Kolkata', 0, 'static', 'theme', NULL, 'https://menu.dovishfinancialservices.com', 0, 'https://www.facebook.com/', 'https://www.instagram.com/', 'https://www.twitter.com/', NULL, 5, 1, NULL, NULL, NULL, 'android-chrome-192x192.png', 'android-chrome-512x512.png', 'apple-touch-icon.png', 'favicon-16x16.png', 'favicon-32x32.png', 'favicon.ico', 'e999d9dadd24950038d81c0e25244453', NULL, '0');

-- --------------------------------------------------------

--
-- Table structure for table `global_subscriptions`
--

CREATE TABLE `global_subscriptions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `package_id` bigint(20) UNSIGNED DEFAULT NULL,
  `currency_id` bigint(20) UNSIGNED DEFAULT NULL,
  `package_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `plan_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quantity` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_plan` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_price` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gateway_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trial_ends_at` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscription_status` enum('active','inactive') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `subscribed_on_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `subscription_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flutterwave_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flutterwave_payment_ref` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flutterwave_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flutterwave_customer_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `global_subscriptions`
--

INSERT INTO `global_subscriptions` (`id`, `restaurant_id`, `package_id`, `currency_id`, `package_type`, `plan_type`, `transaction_id`, `name`, `user_id`, `quantity`, `token`, `razorpay_id`, `razorpay_plan`, `stripe_id`, `stripe_status`, `stripe_price`, `gateway_name`, `trial_ends_at`, `subscription_status`, `ends_at`, `subscribed_on_date`, `created_at`, `updated_at`, `subscription_id`, `customer_id`, `flutterwave_id`, `flutterwave_payment_ref`, `flutterwave_status`, `flutterwave_customer_id`) VALUES
(1, 1, 5, 1, 'trial', NULL, 'MUJRWLIQDSKZPQC', NULL, NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, 'offline', '2025-06-28 11:23:00', 'inactive', '2025-06-28 11:23:00', '2025-05-29 11:23:00', '2025-05-29 11:23:00', '2025-06-28 00:00:06', NULL, NULL, NULL, NULL, NULL, NULL),
(2, 2, 5, 1, 'trial', NULL, 'Y6QNIBAICE8BOXU', NULL, NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, 'offline', '2025-06-28 12:11:59', 'inactive', '2025-06-28 12:11:59', '2025-05-29 12:11:59', '2025-05-29 12:11:59', '2025-05-29 12:13:31', NULL, NULL, NULL, NULL, NULL, NULL),
(3, 2, 5, 1, 'free', NULL, 'ADTEYT8EDUEGL0X', NULL, NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, 'offline', NULL, 'active', '2030-06-28 00:00:00', '2025-05-29 00:00:00', '2025-05-29 12:13:31', '2025-05-29 12:13:31', NULL, NULL, NULL, NULL, NULL, NULL),
(4, 1, 1, 1, 'monthly', NULL, 'KLMUR92BUPHTY0L', NULL, NULL, '1', NULL, NULL, NULL, NULL, NULL, NULL, 'offline', NULL, 'active', '2025-07-28 00:00:00', '2025-06-28 00:00:06', '2025-06-28 00:00:06', '2025-06-28 00:00:06', NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `item_categories`
--

CREATE TABLE `item_categories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `category_name` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `item_categories`
--

INSERT INTO `item_categories` (`id`, `branch_id`, `category_name`, `created_at`, `updated_at`) VALUES
(1, 3, '{\"en\":\"Starters\"}', '2025-05-29 13:19:58', '2025-05-29 13:19:58'),
(2, 3, '{\"en\":\"Main Course\"}', '2025-05-29 15:01:52', '2025-05-29 15:01:52'),
(3, 3, '{\"en\":\"Breads\"}', '2025-05-29 15:02:03', '2025-05-29 15:02:03'),
(4, 3, '{\"en\":\"Desserts\"}', '2025-05-29 15:02:18', '2025-05-29 15:02:18'),
(5, 3, '{\"en\":\"Beverages\"}', '2025-05-29 15:02:26', '2025-05-29 15:02:26'),
(6, 3, '{\"en\":\"Snacks\"}', '2025-05-29 15:02:34', '2025-05-29 15:02:34');

-- --------------------------------------------------------

--
-- Table structure for table `item_modifiers`
--

CREATE TABLE `item_modifiers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `menu_item_id` bigint(20) UNSIGNED DEFAULT NULL,
  `modifier_group_id` bigint(20) UNSIGNED DEFAULT NULL,
  `is_required` tinyint(1) NOT NULL DEFAULT '0',
  `allow_multiple_selection` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `jobs`
--

CREATE TABLE `jobs` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) UNSIGNED NOT NULL,
  `reserved_at` int(10) UNSIGNED DEFAULT NULL,
  `available_at` int(10) UNSIGNED NOT NULL,
  `created_at` int(10) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `job_batches`
--

CREATE TABLE `job_batches` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `kots`
--

CREATE TABLE `kots` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `kot_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order_id` bigint(20) UNSIGNED NOT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `status` enum('pending_confirmation','in_kitchen','food_ready','served') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'in_kitchen',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `kots`
--

INSERT INTO `kots` (`id`, `branch_id`, `kot_number`, `order_id`, `transaction_id`, `note`, `status`, `created_at`, `updated_at`) VALUES
(1, 3, '2', 2, 'TXN_6838603b2d8db3.40781149_410452', NULL, 'food_ready', '2025-05-29 13:25:15', '2025-05-29 15:38:40'),
(2, 3, '4', 3, 'TXN_68386588771607.55287542_907924', NULL, 'in_kitchen', '2025-05-29 13:47:52', '2025-06-16 11:40:42'),
(3, 3, '6', 4, 'TXN_68388080f233f1.48688461_681054', NULL, 'served', '2025-05-29 15:42:56', '2025-05-29 15:50:41'),
(4, 3, '8', 5, 'TXN_684b04b46915c0.93217140_937441', NULL, 'food_ready', '2025-06-12 16:47:48', '2025-06-12 16:59:25'),
(5, 3, '10', 6, 'TXN_684c07a401a2f8.32175591_624102', NULL, 'pending_confirmation', '2025-06-13 11:12:36', '2025-06-13 11:12:36'),
(6, 3, '12', 7, 'TXN_684c0dc0499604.54711024_844319', NULL, 'in_kitchen', '2025-06-13 11:38:40', '2025-07-29 02:01:44'),
(7, 3, '14', 6, 'TXN_684c0e02bab215.56197626_493642', NULL, 'pending_confirmation', '2025-06-13 11:39:46', '2025-06-13 11:39:46'),
(8, 3, '16', 9, 'TXN_684d42809be625.48773484_112813', NULL, 'pending_confirmation', '2025-06-14 09:36:00', '2025-06-14 09:36:00'),
(9, 3, '18', 5, NULL, NULL, 'served', '2025-06-16 10:07:42', '2025-06-16 10:10:22'),
(10, 3, '20', 1, NULL, NULL, 'served', '2025-06-16 10:13:19', '2025-06-16 10:14:20'),
(11, 3, '22', 10, 'TXN_685002684914b2.87875851_887950', NULL, 'pending_confirmation', '2025-06-16 11:39:20', '2025-06-16 11:39:20'),
(12, 3, '24', 3, NULL, NULL, 'served', '2025-06-16 12:01:25', '2025-06-16 12:03:19'),
(13, 3, '26', 10, 'TXN_68500f7de38b33.54372554_323061', NULL, 'pending_confirmation', '2025-06-16 12:35:09', '2025-06-16 12:35:09'),
(14, 3, '28', 11, 'TXN_68501047087a56.05034943_355642', NULL, 'served', '2025-06-16 12:38:31', '2025-06-16 12:42:38'),
(15, 3, '30', 12, 'TXN_6850142019e0f3.33810040_114636', 'I want more salt', 'served', '2025-06-16 12:54:56', '2025-06-16 12:58:37'),
(16, 3, '32', 13, 'TXN_6850142041e270.90614951_133008', 'I want more salt', 'served', '2025-06-16 12:54:56', '2025-06-16 13:11:24'),
(17, 3, '32', 13, 'TXN_6850178d9235b6.26831137_452594', 'I want salt extra jimbo', 'served', '2025-06-16 13:09:33', '2025-06-16 13:15:48'),
(19, 3, '34', 15, 'TXN_68501ae2d00191.16937136_672837', 'I want it hot', 'served', '2025-06-16 13:23:46', '2025-06-16 13:26:12'),
(20, 3, '36', 16, 'TXN_68501ae2e9b4d0.82990904_793563', 'I want it hot', 'served', '2025-06-16 13:23:46', '2025-06-16 13:37:56'),
(21, 3, '36', 17, 'TXN_68501daf8dae09.14752966_815639', 'I want want more salt', 'pending_confirmation', '2025-06-16 13:35:43', '2025-06-16 13:35:43'),
(22, 3, '38', 18, 'TXN_68501de00a5828.96329917_755786', NULL, 'served', '2025-06-16 13:36:32', '2025-06-16 13:43:59'),
(23, 3, '40', 19, 'TXN_68501f733bc076.84956524_931308', NULL, 'served', '2025-06-16 13:43:15', '2025-06-16 13:45:27'),
(24, 3, '42', 20, 'TXN_685020b70e2804.64103332_770945', NULL, 'served', '2025-06-16 13:48:39', '2025-06-16 13:50:40'),
(25, 3, '44', 21, 'TXN_68519ac29ef1b7.61805166_722210', NULL, 'pending_confirmation', '2025-06-17 16:41:38', '2025-06-17 16:41:38'),
(26, 3, '46', 22, 'TXN_6853e03a305e02.41204263_882236', NULL, 'pending_confirmation', '2025-06-19 10:02:34', '2025-06-19 10:02:34'),
(27, 3, '48', 23, 'TXN_6853e0bac2a347.97477176_447752', NULL, 'pending_confirmation', '2025-06-19 10:04:42', '2025-06-19 10:04:42'),
(28, 3, '50', 24, 'TXN_6853e1f805de78.61911534_651017', NULL, 'food_ready', '2025-06-19 10:10:00', '2025-06-19 10:12:21'),
(29, 3, '52', 23, 'TXN_6853e247e1e5c0.75061441_693230', NULL, 'pending_confirmation', '2025-06-19 10:11:19', '2025-06-19 10:11:19'),
(30, 3, '54', 25, 'TXN_6853e2f80972b6.10183473_561139', NULL, 'in_kitchen', '2025-06-19 10:14:16', '2025-06-19 10:16:44'),
(31, 3, '56', 25, 'TXN_6853e332c8dd57.32259557_618325', NULL, 'in_kitchen', '2025-06-19 10:15:14', '2025-06-19 10:16:44'),
(32, 3, '58', 26, 'TXN_6853eadbe35d45.77833331_212971', NULL, 'food_ready', '2025-06-19 10:47:55', '2025-06-19 10:52:46'),
(33, 3, '60', 27, 'TXN_687e6b426d1579.01583867_400781', NULL, 'in_kitchen', '2025-07-21 16:30:58', '2025-07-21 16:30:58'),
(34, 3, '62', 27, 'TXN_687e6d6391df58.26437677_327426', NULL, 'in_kitchen', '2025-07-21 16:40:03', '2025-07-21 16:40:03'),
(35, 3, '64', 28, 'TXN_687e6e63364611.82563565_238025', NULL, 'served', '2025-07-21 16:44:19', '2025-07-21 16:49:26');

-- --------------------------------------------------------

--
-- Table structure for table `kot_items`
--

CREATE TABLE `kot_items` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `kot_id` bigint(20) UNSIGNED NOT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `menu_item_id` bigint(20) UNSIGNED NOT NULL,
  `menu_item_variation_id` bigint(20) UNSIGNED DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `kot_items`
--

INSERT INTO `kot_items` (`id`, `kot_id`, `transaction_id`, `menu_item_id`, `menu_item_variation_id`, `quantity`, `created_at`, `updated_at`) VALUES
(1, 1, 'TXN_6838603b2d8db3.40781149_410452', 1, NULL, 1, '2025-05-29 13:25:15', '2025-05-29 13:25:15'),
(2, 2, 'TXN_68386588771607.55287542_907924', 1, NULL, 1, '2025-05-29 13:47:52', '2025-05-29 13:47:52'),
(3, 3, 'TXN_68388080f233f1.48688461_681054', 2, NULL, 2, '2025-05-29 15:42:56', '2025-05-29 15:42:56'),
(4, 4, 'TXN_684b04b46915c0.93217140_937441', 6, NULL, 1, '2025-06-12 16:47:48', '2025-06-12 16:47:48'),
(5, 5, 'TXN_684c07a401a2f8.32175591_624102', 8, NULL, 1, '2025-06-13 11:12:36', '2025-06-13 11:12:36'),
(6, 6, 'TXN_684c0dc0499604.54711024_844319', 8, NULL, 1, '2025-06-13 11:38:40', '2025-06-13 11:38:40'),
(7, 6, 'TXN_684c0dc0499604.54711024_844319', 5, NULL, 1, '2025-06-13 11:38:40', '2025-06-13 11:38:40'),
(8, 6, 'TXN_684c0dc0499604.54711024_844319', 1, NULL, 1, '2025-06-13 11:38:40', '2025-06-13 11:38:40'),
(9, 6, 'TXN_684c0dc0499604.54711024_844319', 11, NULL, 1, '2025-06-13 11:38:40', '2025-06-13 11:38:40'),
(10, 7, 'TXN_684c0e02bab215.56197626_493642', 3, NULL, 1, '2025-06-13 11:39:46', '2025-06-13 11:39:46'),
(11, 8, 'TXN_684d42809be625.48773484_112813', 8, NULL, 1, '2025-06-14 09:36:00', '2025-06-14 09:36:00'),
(12, 8, 'TXN_684d42809be625.48773484_112813', 4, NULL, 1, '2025-06-14 09:36:00', '2025-06-14 09:36:00'),
(13, 9, NULL, 4, NULL, 1, '2025-06-16 10:07:42', '2025-06-16 10:07:42'),
(14, 9, NULL, 5, NULL, 1, '2025-06-16 10:07:42', '2025-06-16 10:07:42'),
(15, 10, NULL, 3, NULL, 1, '2025-06-16 10:13:19', '2025-06-16 10:13:19'),
(16, 11, 'TXN_685002684914b2.87875851_887950', 9, NULL, 1, '2025-06-16 11:39:20', '2025-06-16 11:39:20'),
(17, 12, NULL, 3, NULL, 1, '2025-06-16 12:01:25', '2025-06-16 12:01:25'),
(18, 13, 'TXN_68500f7de38b33.54372554_323061', 8, NULL, 1, '2025-06-16 12:35:09', '2025-06-16 12:35:09'),
(19, 14, 'TXN_68501047087a56.05034943_355642', 8, NULL, 1, '2025-06-16 12:38:31', '2025-06-16 12:38:31'),
(20, 15, 'TXN_6850142019e0f3.33810040_114636', 2, NULL, 1, '2025-06-16 12:54:56', '2025-06-16 12:54:56'),
(21, 16, 'TXN_6850142041e270.90614951_133008', 2, NULL, 1, '2025-06-16 12:54:56', '2025-06-16 12:54:56'),
(22, 17, 'TXN_6850178d9235b6.26831137_452594', 4, NULL, 1, '2025-06-16 13:09:33', '2025-06-16 13:09:33'),
(24, 19, 'TXN_68501ae2d00191.16937136_672837', 9, NULL, 1, '2025-06-16 13:23:46', '2025-06-16 13:23:46'),
(25, 20, 'TXN_68501ae2e9b4d0.82990904_793563', 9, NULL, 1, '2025-06-16 13:23:46', '2025-06-16 13:23:46'),
(26, 21, 'TXN_68501daf8dae09.14752966_815639', 3, NULL, 1, '2025-06-16 13:35:43', '2025-06-16 13:35:43'),
(27, 22, 'TXN_68501de00a5828.96329917_755786', 8, NULL, 4, '2025-06-16 13:36:32', '2025-06-16 13:36:32'),
(28, 23, 'TXN_68501f733bc076.84956524_931308', 11, NULL, 1, '2025-06-16 13:43:15', '2025-06-16 13:43:15'),
(29, 24, 'TXN_685020b70e2804.64103332_770945', 9, NULL, 2, '2025-06-16 13:48:39', '2025-06-16 13:48:39'),
(30, 25, 'TXN_68519ac29ef1b7.61805166_722210', 9, NULL, 1, '2025-06-17 16:41:38', '2025-06-17 16:41:38'),
(31, 25, 'TXN_68519ac29ef1b7.61805166_722210', 8, NULL, 1, '2025-06-17 16:41:38', '2025-06-17 16:41:38'),
(32, 26, 'TXN_6853e03a305e02.41204263_882236', 9, NULL, 2, '2025-06-19 10:02:34', '2025-06-19 10:02:34'),
(33, 27, 'TXN_6853e0bac2a347.97477176_447752', 8, NULL, 1, '2025-06-19 10:04:42', '2025-06-19 10:04:42'),
(34, 28, 'TXN_6853e1f805de78.61911534_651017', 1, NULL, 1, '2025-06-19 10:10:00', '2025-06-19 10:10:00'),
(35, 29, 'TXN_6853e247e1e5c0.75061441_693230', 9, NULL, 1, '2025-06-19 10:11:19', '2025-06-19 10:11:19'),
(36, 29, 'TXN_6853e247e1e5c0.75061441_693230', 2, NULL, 1, '2025-06-19 10:11:19', '2025-06-19 10:11:19'),
(37, 30, 'TXN_6853e2f80972b6.10183473_561139', 8, NULL, 1, '2025-06-19 10:14:16', '2025-06-19 10:14:16'),
(38, 30, 'TXN_6853e2f80972b6.10183473_561139', 9, NULL, 1, '2025-06-19 10:14:16', '2025-06-19 10:14:16'),
(39, 31, 'TXN_6853e332c8dd57.32259557_618325', 8, NULL, 4, '2025-06-19 10:15:14', '2025-06-19 10:15:14'),
(40, 31, 'TXN_6853e332c8dd57.32259557_618325', 9, NULL, 1, '2025-06-19 10:15:14', '2025-06-19 10:15:14'),
(41, 32, 'TXN_6853eadbe35d45.77833331_212971', 2, NULL, 1, '2025-06-19 10:47:55', '2025-06-19 10:47:55'),
(42, 32, 'TXN_6853eadbe35d45.77833331_212971', 9, NULL, 1, '2025-06-19 10:47:55', '2025-06-19 10:47:55'),
(43, 33, 'TXN_687e6b426d1579.01583867_400781', 8, NULL, 1, '2025-07-21 16:30:58', '2025-07-21 16:30:58'),
(44, 33, 'TXN_687e6b426d1579.01583867_400781', 9, NULL, 1, '2025-07-21 16:30:58', '2025-07-21 16:30:58'),
(45, 34, 'TXN_687e6d6391df58.26437677_327426', 8, NULL, 1, '2025-07-21 16:40:03', '2025-07-21 16:40:03'),
(46, 34, 'TXN_687e6d6391df58.26437677_327426', 2, NULL, 1, '2025-07-21 16:40:03', '2025-07-21 16:40:03'),
(47, 35, 'TXN_687e6e63364611.82563565_238025', 3, NULL, 1, '2025-07-21 16:44:19', '2025-07-21 16:44:19'),
(48, 35, 'TXN_687e6e63364611.82563565_238025', 4, NULL, 1, '2025-07-21 16:44:19', '2025-07-21 16:44:19');

-- --------------------------------------------------------

--
-- Table structure for table `kot_item_modifier_options`
--

CREATE TABLE `kot_item_modifier_options` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `kot_item_id` bigint(20) UNSIGNED NOT NULL,
  `modifier_option_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `language_settings`
--

CREATE TABLE `language_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `language_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `flag_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `is_rtl` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `language_settings`
--

INSERT INTO `language_settings` (`id`, `language_code`, `language_name`, `flag_code`, `active`, `is_rtl`, `created_at`, `updated_at`) VALUES
(1, 'en', 'English', 'gb', 1, 0, NULL, NULL),
(2, 'ar', 'Arabic', 'sa', 0, 0, NULL, NULL),
(3, 'de', 'German', 'de', 0, 0, NULL, NULL),
(4, 'es', 'Spanish', 'es', 0, 0, NULL, NULL),
(5, 'et', 'Estonian', 'et', 0, 0, NULL, NULL),
(6, 'fa', 'Farsi', 'ir', 0, 0, NULL, NULL),
(7, 'fr', 'French', 'fr', 0, 0, NULL, NULL),
(8, 'gr', 'Greek', 'gr', 0, 0, NULL, NULL),
(9, 'it', 'Italian', 'it', 0, 0, NULL, NULL),
(10, 'nl', 'Dutch', 'nl', 0, 0, NULL, NULL),
(11, 'pl', 'Polish', 'pl', 0, 0, NULL, NULL),
(12, 'pt', 'Portuguese', 'pt', 0, 0, NULL, NULL),
(13, 'pt-br', 'Portuguese (Brazil)', 'br', 0, 0, NULL, NULL),
(14, 'ro', 'Romanian', 'ro', 0, 0, NULL, NULL),
(15, 'ru', 'Russian', 'ru', 0, 0, NULL, NULL),
(16, 'tr', 'Turkish', 'tr', 0, 0, NULL, NULL),
(17, 'zh-CN', 'Chinese (S)', 'cn', 0, 0, NULL, NULL),
(18, 'zh-TW', 'Chinese (T)', 'cn', 0, 0, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ltm_translations`
--

CREATE TABLE `ltm_translations` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `locale` varchar(191) COLLATE utf8mb4_bin NOT NULL,
  `group` varchar(191) COLLATE utf8mb4_bin NOT NULL,
  `key` text COLLATE utf8mb4_bin NOT NULL,
  `value` text COLLATE utf8mb4_bin,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;

-- --------------------------------------------------------

--
-- Table structure for table `menus`
--

CREATE TABLE `menus` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `menu_name` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `menus`
--

INSERT INTO `menus` (`id`, `branch_id`, `menu_name`, `created_at`, `updated_at`) VALUES
(1, 3, '{\"en\":\"Breakfast\"}', '2025-05-29 13:17:45', '2025-05-29 13:17:45'),
(2, 3, '{\"en\":\"Lunch\"}', '2025-05-29 14:59:36', '2025-05-29 14:59:36'),
(3, 3, '{\"en\":\"Dinner\"}', '2025-05-29 14:59:47', '2025-05-29 14:59:47');

-- --------------------------------------------------------

--
-- Table structure for table `menu_items`
--

CREATE TABLE `menu_items` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `item_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `type` enum('veg','non-veg','egg','drink','other') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'veg',
  `price` decimal(16,2) DEFAULT NULL,
  `menu_id` bigint(20) UNSIGNED NOT NULL,
  `item_category_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `preparation_time` int(11) DEFAULT NULL,
  `is_available` tinyint(1) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `menu_items`
--

INSERT INTO `menu_items` (`id`, `branch_id`, `item_name`, `image`, `description`, `type`, `price`, `menu_id`, `item_category_id`, `created_at`, `updated_at`, `preparation_time`, `is_available`) VALUES
(1, 3, 'Spring Rolls', 'aa08e86b5f865d18cfba0375a9e07727.jpg', 'Crispy rolls stuffed with a mix of vegetables and served with tangy dip.', 'veg', 299.99, 1, 1, '2025-05-29 13:20:38', '2025-07-29 11:13:21', 14, 1),
(2, 3, 'Veg Manchow Soup', 'cf4d941412321df84a1abd69ebfd92af.jpg', 'Spicy vegetable soup with crispy fried noodles.', 'veg', 349.99, 2, 2, '2025-05-29 15:06:04', '2025-05-29 15:06:05', 9, 1),
(3, 3, 'Chilli Paneer', 'aca3528e2b37199efae9530757d7eb4c.jpg', 'Spicy cottage cheese cubes tossed in a tangy Indo-Chinese sauce.', 'veg', 400.00, 2, 2, '2025-05-29 15:07:25', '2025-05-29 15:07:25', 10, 1),
(4, 3, 'Vegetable Hakka Noodles', '4abe7150b0abbf7cc18c4614eebeaa01.jpeg', 'Stir-fried noodles with a mix of vegetables in a savory sauce.', 'veg', 380.00, 3, 2, '2025-05-29 15:08:43', '2025-05-29 15:08:43', 7, 1),
(5, 3, 'Chicken Manchurian', 'e82cc5a400ea04a08385b29e4541a05c.webp', 'Juicy chicken balls in a tangy Manchurian sauce.', 'veg', 290.00, 3, 2, '2025-05-29 15:09:53', '2025-05-29 15:09:53', 12, 1),
(6, 3, 'Idli Sambar', '417cbae466faffd39f0a5fa657f576d2.jpg', 'Steamed rice cakes served with lentil soup and chutney.', 'egg', 250.00, 2, 2, '2025-05-29 15:11:15', '2025-05-29 15:11:16', 8, 1),
(7, 3, 'Masala Dosa', '08952746ea2b455e25eaa1e03ca1d37c.jpg', 'Crispy rice and lentil crepe filled with spiced mashed potatoes.', 'veg', 550.00, 1, 2, '2025-05-29 15:12:27', '2025-05-29 15:12:28', 10, 1),
(8, 3, 'Naan', '8326fb16c4789ad208bcab86dadddbfa.jpg', 'Soft and fluffy bread baked in a tandoor.', 'other', 200.00, 1, 3, '2025-05-29 15:13:45', '2025-06-17 18:32:03', 5, 1),
(9, 3, 'Tandoori Roti', '2c834d958aa624f4bbbce2511d589f2b.jpg', 'Traditional whole wheat bread cooked in a clay oven.', 'egg', 190.00, 3, 4, '2025-05-29 15:15:16', '2025-05-29 15:15:17', 4, 1),
(10, 3, 'Dal Makhani', '3a74ebd08dd5062811ef3d193a672710.jpg', 'Creamy and rich black lentils cooked with butter and spices.', 'non-veg', 360.00, 2, 2, '2025-05-29 15:16:16', '2025-05-29 15:16:17', 7, 1),
(11, 3, 'Paneer Tikka', '86238133edf6323defca06dd237d899a.jpg', 'Grilled cottage cheese marinated in spicy yogurt.', 'veg', 400.00, 3, 1, '2025-05-29 15:17:27', '2025-05-29 15:17:28', 20, 1);

-- --------------------------------------------------------

--
-- Table structure for table `menu_item_translations`
--

CREATE TABLE `menu_item_translations` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `menu_item_id` bigint(20) UNSIGNED NOT NULL,
  `locale` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `menu_item_translations`
--

INSERT INTO `menu_item_translations` (`id`, `menu_item_id`, `locale`, `item_name`, `description`) VALUES
(1, 1, 'en', 'Spring Rolls', 'Crispy rolls stuffed with a mix of vegetables and served with tangy dip.'),
(2, 2, 'en', 'Veg Manchow Soup', 'Spicy vegetable soup with crispy fried noodles.'),
(3, 3, 'en', 'Chilli Paneer', 'Spicy cottage cheese cubes tossed in a tangy Indo-Chinese sauce.'),
(4, 4, 'en', 'Vegetable Hakka Noodles', 'Stir-fried noodles with a mix of vegetables in a savory sauce.'),
(5, 5, 'en', 'Chicken Manchurian', 'Juicy chicken balls in a tangy Manchurian sauce.'),
(6, 6, 'en', 'Idli Sambar', 'Steamed rice cakes served with lentil soup and chutney.'),
(7, 7, 'en', 'Masala Dosa', 'Crispy rice and lentil crepe filled with spiced mashed potatoes.'),
(8, 8, 'en', 'Naan', 'Soft and fluffy bread baked in a tandoor.'),
(9, 9, 'en', 'Tandoori Roti', 'Traditional whole wheat bread cooked in a clay oven.'),
(10, 10, 'en', 'Dal Makhani', 'Creamy and rich black lentils cooked with butter and spices.'),
(11, 11, 'en', 'Paneer Tikka', 'Grilled cottage cheese marinated in spicy yogurt.');

-- --------------------------------------------------------

--
-- Table structure for table `menu_item_variations`
--

CREATE TABLE `menu_item_variations` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `variation` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(16,2) NOT NULL,
  `menu_item_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `migrations`
--

CREATE TABLE `migrations` (
  `id` int(10) UNSIGNED NOT NULL,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `migrations`
--

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
(1, '0001_01_01_000000_create_users_table', 1),
(2, '0001_01_01_000001_create_cache_table', 1),
(3, '0001_01_01_000002_create_jobs_table', 1),
(4, '2014_04_02_193005_create_translations_table', 1),
(5, '2024_03_13_000002_create_expense_categories_table', 1),
(6, '2024_07_01_060651_add_two_factor_columns_to_users_table', 1),
(7, '2024_07_01_060707_create_personal_access_tokens_table', 1),
(8, '2024_07_02_064204_create_menus_table', 1),
(9, '2024_07_12_070634_create_areas_table', 1),
(10, '2024_07_16_103816_create_orders_table', 1),
(11, '2024_07_21_083459_add_user_type_column', 1),
(12, '2024_07_24_131631_create_payments_table', 1),
(13, '2024_07_31_081306_add_email_otp_column', 1),
(14, '2024_08_02_061808_create_countries_table', 1),
(15, '2024_08_02_071637_create_restaurant_settings_table', 1),
(16, '2024_08_04_104258_create_razorpay_payments_table', 1),
(17, '2024_08_05_092258_create_stripe_payments_table', 1),
(18, '2024_08_05_110157_create_payment_gateway_credentials_table', 1),
(19, '2024_08_13_033139_create_global_settings_table', 1),
(20, '2024_08_13_073129_update_settings_add_envato_key', 1),
(21, '2024_08_13_073129_update_settings_add_support_key', 1),
(22, '2024_08_14_073129_update_settings_add_email', 1),
(23, '2024_08_14_073129_update_settings_add_last_verified_key', 1),
(24, '2024_09_13_081726_create_modules_table', 1),
(25, '2024_09_14_130619_create_permission_tables', 1),
(26, '2024_09_27_071339_create_reservations_table', 1),
(27, '2024_10_02_090924_create_email_settings_table', 1),
(28, '2024_10_03_073837_create_notification_settings_table', 1),
(29, '2024_10_11_100539_create_branches_table', 1),
(30, '2024_10_14_121135_create_onboarding_steps_table', 1),
(31, '2024_10_15_071238_add_restaurant_hash_column', 1),
(32, '2024_10_15_071238_storage', 1),
(33, '2024_10_15_100639_create_restaurant_payments_table', 1),
(34, '2024_10_27_101326_create_packages_table', 1),
(35, '2024_11_02_112920_create_language_settings_table', 1),
(36, '2024_11_02_120314_create_flags_table', 1),
(37, '2024_11_02_120314_email_settings_table', 1),
(38, '2024_11_08_071617_add_customer_login_required_column', 1),
(39, '2024_11_08_093032_create_superadmin_payment_gateways_table', 1),
(40, '2024_11_08_133506_add_stripe_column_for_license', 1),
(41, '2024_11_12_055119_create_delivery_executives_table', 1),
(42, '2024_11_12_055632_add_order_types_column', 1),
(43, '2024_11_12_060500_create_order_histories_table', 1),
(44, '2024_11_12_060500_global_license_type_table', 1),
(45, '2024_11_12_060500_global_purchase_on_table', 1),
(46, '2024_11_12_060500_global_setting_timezone_table', 1),
(47, '2024_11_17_052707_currency_position', 1),
(48, '2024_11_17_052707_move_qr_code', 1),
(49, '2024_11_19_113852_add_is_active_to_restaurants_table', 1),
(50, '2024_11_20_114816_add_staff_welcome_email_notification', 1),
(51, '2024_11_25_061322_create_pusher_settings_table', 1),
(52, '2024_11_26_090216_create_global_currencies_table', 1),
(53, '2024_12_03_085842_add_about_us_column', 1),
(54, '2024_12_03_104817_add_currency_id_packages', 1),
(55, '2024_12_04_080223_add_allow_customer_delivery_orders', 1),
(56, '2024_12_04_115601_add_preparation_time_column', 1),
(57, '2024_12_11_110000_create_tables_for_subscription_table', 1),
(58, '2024_12_11_131225_add_disable_landing_site_columns', 1),
(59, '2024_12_12_090840_create_waiter_requests_table', 1),
(60, '2024_12_13_090840_add_domain_global_setting', 1),
(61, '2024_12_16_080201_create_lifetime_subscriptions_for_paid_restaurants', 1),
(62, '2024_12_23_124452_add_payment_enabled_columns_to_payment_settings_table', 1),
(63, '2024_12_27_054246_add_table_reservation_default_status_to_restaurants_table', 1),
(64, '2024_12_30_074018_create_split_orders_table', 1),
(65, '2024_12_30_200942_create_restaurant_settings_table', 1),
(66, '2025_01_03_050139_add_social_media_links_to_reataurants_table', 1),
(67, '2025_01_03_093938_add_social_media_links_to_global_settings_table', 1),
(68, '2025_01_06_111550_create_receipt_settings_table', 1),
(69, '2025_01_09_073145_generate_qr_codes_for_existing_branches', 1),
(70, '2025_01_09_115652_update_receipt_settings_for_existing_restaurants', 1),
(71, '2025_01_10_064103_add_table_required_column_to_customer_settings_table', 1),
(72, '2025_01_10_100552_insert_to_file_storage_settings_default_values', 1),
(73, '2025_01_11_063817_add_default_currency_column', 1),
(74, '2025_01_16_125322_add_is_enabled_to_menu_items_table', 1),
(75, '2025_01_16_131100_regenrate_qr_codes', 1),
(76, '2025_01_20_000000_add_restaurant_id_to_roles', 1),
(77, '2025_01_20_071544_add_branch_limit_to_packages_table', 1),
(78, '2025_01_20_091630_update_item_type', 1),
(79, '2025_01_20_125429_add_discount_columns_to_orders_table', 1),
(80, '2025_01_21_064139_add_show_logo_text_column', 1),
(81, '2025_01_21_064256_add_offline_payment', 1),
(82, '2025_01_21_132218_fix_user_roles', 1),
(83, '2025_01_22_114720_add_show_tax_to_receipt_setting', 1),
(84, '2025_01_23_065746_create_modifier_groups_table', 1),
(85, '2025_01_23_085333_create_restaurant_taxes_table', 1),
(86, '2025_01_23_090554_create_modifier_options_table', 1),
(87, '2025_01_23_094318_create_item_modifiers_table', 1),
(88, '2025_01_23_121154_create_order_item_modifier_options_table', 1),
(89, '2025_01_27_065822_add_balance_column_to_payment', 1),
(90, '2025_01_28_111039_add_allow_dine_in_orders_to_restaurant', 1),
(91, '2025_01_30_050755_add_yelp_icon_to_global_settings', 1),
(92, '2025_01_30_055744_add_yelp_link_to_restaurants', 1),
(93, '2025_01_30_100556_fix_package_price_length', 1),
(94, '2025_01_30_104043_add_meta_data_to_global_settings', 1),
(95, '2025_02_03_062109_add_is_cash_payment_enabled_to_payment', 1),
(96, '2025_02_04_140538_add_transaction_id_kot', 1),
(97, '2025_02_15_121956_add_hide_new_orders_option_to_restaurant', 1),
(98, '2025_02_17_052801_create_restaurant_charges_settings_table', 1),
(99, '2025_02_17_093729_add_favicon_to_restaurant', 1),
(100, '2025_02_19_091730_update_menu_name_to_json', 1),
(101, '2025_02_20_095321_add_waiter_request_options_to_restaurant', 1),
(102, '2025_02_21_051534_add_hash_to_global_settings_table', 1),
(103, '2025_02_21_102116_add_column_to_settings', 1),
(104, '2025_02_24_063827_add_payment_qr_to_receipt_settings', 1),
(105, '2025_02_24_111946_add_permissions_to_customers', 1),
(106, '2025_03_04_114535_add_is_enabled_to_restaurant_charges', 1),
(107, '2025_03_10_055100_add_tip_column_to_orders_table', 1),
(108, '2025_03_10_100727_add_is_pwa_intall_alert_show_column_in_restaurants_table', 1),
(109, '2025_03_17_090450_add_meta_title_to_global_settings', 1),
(110, '2025_03_18_044410_create_expenses_table', 1),
(111, '2025_03_19_092459_create_custom_menus_table', 1),
(112, '2025_03_19_103047_update_additional_modules', 1),
(113, '2025_03_24_084350_add_show_payments_column_to_receipt_settings_table', 1),
(114, '2025_04_01_050059_add_branch_id_to_expense_category', 1),
(115, '2025_04_01_051356_add_branch_id_to_expenses', 1),
(116, '2025_04_02_071911_update_kot_status_enum', 1),
(117, '2025_04_07_112351_add_payment_recived_status_to_orders_table', 1),
(118, '2025_04_08_063624_update_meta_keywords', 1),
(119, '2025_04_10_065753_add_flutterwave_payment_gateway_columns_and_tables', 1),
(120, '2025_04_15_084543_create_front_details_table', 1),
(121, '2025_04_22_065157_create_front_reviews_setting_table', 1),
(122, '2025_04_22_091055_create_branch_delivery_settings_table', 1),
(123, '2025_04_22_091146_create_customer_addresses_table', 1),
(124, '2025_04_22_091223_create_delivery_fee_tiers_table', 1),
(125, '2025_04_22_091258_add_delivery_columns_to_orders_table', 1),
(126, '2025_04_29_102014_add_landing_type_column_in_global_settings_table', 1),
(127, '2025_04_29_114538_add_front_data_in_front_details_table', 1);

-- --------------------------------------------------------

--
-- Table structure for table `model_has_permissions`
--

CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `model_has_roles`
--

CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) UNSIGNED NOT NULL,
  `model_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `model_has_roles`
--

INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
(1, 'App\\Models\\User', 1),
(2, 'App\\Models\\User', 2),
(4, 'App\\Models\\User', 3),
(6, 'App\\Models\\User', 4),
(9, 'App\\Models\\User', 5),
(8, 'App\\Models\\User', 6);

-- --------------------------------------------------------

--
-- Table structure for table `modifier_groups`
--

CREATE TABLE `modifier_groups` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `modifier_options`
--

CREATE TABLE `modifier_options` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `modifier_group_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(16,2) NOT NULL,
  `is_available` tinyint(1) NOT NULL DEFAULT '1',
  `sort_order` int(11) NOT NULL DEFAULT '0',
  `is_preselected` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `modules`
--

CREATE TABLE `modules` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `modules`
--

INSERT INTO `modules` (`id`, `name`, `created_at`, `updated_at`) VALUES
(1, 'Menu', NULL, NULL),
(2, 'Menu Item', NULL, NULL),
(3, 'Item Category', NULL, NULL),
(4, 'Area', NULL, NULL),
(5, 'Table', NULL, NULL),
(6, 'Reservation', NULL, NULL),
(7, 'KOT', NULL, NULL),
(8, 'Order', NULL, NULL),
(9, 'Customer', NULL, NULL),
(10, 'Staff', NULL, NULL),
(11, 'Payment', NULL, NULL),
(12, 'Report', NULL, NULL),
(13, 'Settings', NULL, NULL),
(14, 'Delivery Executive', NULL, NULL),
(15, 'Waiter Request', NULL, NULL),
(16, 'Expense', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `notification_settings`
--

CREATE TABLE `notification_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `send_email` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `notification_settings`
--

INSERT INTO `notification_settings` (`id`, `restaurant_id`, `type`, `send_email`, `created_at`, `updated_at`) VALUES
(1, 1, 'order_received', 1, NULL, NULL),
(2, 1, 'reservation_confirmed', 1, NULL, NULL),
(3, 1, 'new_reservation', 1, NULL, NULL),
(4, 1, 'order_bill_sent', 1, NULL, NULL),
(5, 1, 'staff_welcome', 1, NULL, NULL),
(6, 2, 'order_received', 1, NULL, NULL),
(7, 2, 'reservation_confirmed', 1, NULL, NULL),
(8, 2, 'new_reservation', 1, NULL, NULL),
(9, 2, 'order_bill_sent', 1, NULL, NULL),
(10, 2, 'staff_welcome', 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `offline_payment_methods`
--

CREATE TABLE `offline_payment_methods` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `offline_plan_changes`
--

CREATE TABLE `offline_plan_changes` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `package_id` bigint(20) UNSIGNED NOT NULL,
  `package_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(16,2) DEFAULT NULL,
  `pay_date` date DEFAULT NULL,
  `next_pay_date` date DEFAULT NULL,
  `invoice_id` bigint(20) UNSIGNED DEFAULT NULL,
  `offline_method_id` bigint(20) UNSIGNED DEFAULT NULL,
  `file_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('verified','pending','rejected') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `remark` text COLLATE utf8mb4_unicode_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `onboarding_steps`
--

CREATE TABLE `onboarding_steps` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `add_area_completed` tinyint(1) NOT NULL DEFAULT '0',
  `add_table_completed` tinyint(1) NOT NULL DEFAULT '0',
  `add_menu_completed` tinyint(1) NOT NULL DEFAULT '0',
  `add_menu_items_completed` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `onboarding_steps`
--

INSERT INTO `onboarding_steps` (`id`, `branch_id`, `add_area_completed`, `add_table_completed`, `add_menu_completed`, `add_menu_items_completed`, `created_at`, `updated_at`) VALUES
(1, 1, 0, 0, 0, 0, '2025-05-29 11:23:00', '2025-05-29 11:23:00'),
(2, 2, 0, 0, 0, 0, '2025-05-29 11:23:00', '2025-05-29 11:23:00'),
(3, 3, 1, 1, 1, 1, '2025-05-29 12:11:59', '2025-05-29 13:20:39');

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `order_number` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date_time` datetime NOT NULL,
  `table_id` bigint(20) UNSIGNED DEFAULT NULL,
  `customer_id` bigint(20) UNSIGNED DEFAULT NULL,
  `number_of_pax` int(11) DEFAULT NULL,
  `waiter_id` bigint(20) UNSIGNED DEFAULT NULL,
  `status` enum('draft','kot','billed','paid','canceled','payment_due','ready','out_for_delivery','delivered','pending_verification') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'kot',
  `sub_total` decimal(16,2) NOT NULL,
  `tip_amount` decimal(16,2) DEFAULT '0.00',
  `tip_note` text COLLATE utf8mb4_unicode_ci,
  `total` decimal(16,2) NOT NULL,
  `amount_paid` decimal(16,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `order_type` enum('dine_in','delivery','pickup') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'dine_in',
  `delivery_executive_id` bigint(20) UNSIGNED DEFAULT NULL,
  `delivery_address` text COLLATE utf8mb4_unicode_ci,
  `delivery_time` datetime DEFAULT NULL,
  `estimated_delivery_time` datetime DEFAULT NULL,
  `split_type` enum('even','custom','items') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_value` decimal(16,2) DEFAULT NULL,
  `discount_amount` decimal(16,2) DEFAULT NULL,
  `order_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'placed',
  `delivery_fee` decimal(8,2) NOT NULL DEFAULT '0.00',
  `customer_lat` decimal(10,7) DEFAULT NULL,
  `customer_lng` decimal(10,7) DEFAULT NULL,
  `is_within_radius` tinyint(1) NOT NULL DEFAULT '0',
  `delivery_started_at` timestamp NULL DEFAULT NULL,
  `delivered_at` timestamp NULL DEFAULT NULL,
  `estimated_eta_min` int(11) DEFAULT NULL,
  `estimated_eta_max` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `orders`
--

INSERT INTO `orders` (`id`, `branch_id`, `order_number`, `date_time`, `table_id`, `customer_id`, `number_of_pax`, `waiter_id`, `status`, `sub_total`, `tip_amount`, `tip_note`, `total`, `amount_paid`, `created_at`, `updated_at`, `order_type`, `delivery_executive_id`, `delivery_address`, `delivery_time`, `estimated_delivery_time`, `split_type`, `discount_type`, `discount_value`, `discount_amount`, `order_status`, `delivery_fee`, `customer_lat`, `customer_lng`, `is_within_radius`, `delivery_started_at`, `delivered_at`, `estimated_eta_min`, `estimated_eta_max`) VALUES
(1, 3, '1', '2025-06-16 10:30:19', 1, NULL, 1, 4, 'paid', 400.00, 0.00, NULL, 400.00, 400.00, '2025-05-29 13:22:39', '2025-06-16 11:02:09', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 0, NULL, NULL, NULL, NULL),
(2, 3, '2', '2025-05-29 15:39:55', NULL, NULL, NULL, 4, 'billed', 9.99, 0.00, NULL, 9.99, 0.00, '2025-05-29 13:25:15', '2025-05-29 15:39:55', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(3, 3, '3', '2025-06-16 12:04:03', 1, NULL, NULL, 6, 'paid', 409.99, 0.00, NULL, 409.99, 409.99, '2025-05-29 13:47:52', '2025-07-29 02:07:04', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(4, 3, '4', '2025-05-29 15:47:02', 7, NULL, NULL, 4, 'paid', 699.98, 0.00, NULL, 699.98, 699.98, '2025-05-29 15:42:56', '2025-06-16 11:03:18', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(5, 3, '5', '2025-06-16 10:08:42', 2, NULL, NULL, 4, 'paid', 920.00, 25.00, '', 945.00, 945.00, '2025-06-12 16:47:48', '2025-06-16 10:59:10', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(6, 3, '6', '2025-06-13 11:12:35', 1, NULL, NULL, NULL, 'kot', 600.00, 0.00, NULL, 600.00, 0.00, '2025-06-13 11:12:36', '2025-06-13 11:39:46', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'placed', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(7, 3, '7', '2025-07-29 02:02:12', 2, NULL, NULL, 6, 'paid', 899.99, 0.00, NULL, 899.99, 899.99, '2025-06-13 11:38:40', '2025-07-29 02:02:32', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(8, 3, '8', '2025-06-13 11:46:12', NULL, NULL, 1, 4, 'billed', 290.00, 0.00, NULL, 290.00, 0.00, '2025-06-13 11:46:12', '2025-06-13 11:46:12', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'preparing', 0.00, NULL, NULL, 0, NULL, NULL, NULL, NULL),
(9, 3, '9', '2025-06-14 09:36:00', 2, NULL, NULL, NULL, 'kot', 580.00, 0.00, NULL, 580.00, 0.00, '2025-06-14 09:36:00', '2025-06-14 09:36:00', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'placed', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(10, 3, '10', '2025-06-16 11:39:20', 1, NULL, NULL, NULL, 'kot', 390.00, 0.00, NULL, 390.00, 0.00, '2025-06-16 11:39:20', '2025-06-16 12:35:09', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'placed', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(11, 3, '11', '2025-06-16 12:44:00', 4, NULL, NULL, 6, 'paid', 200.00, 0.00, NULL, 200.00, 200.00, '2025-06-16 12:38:31', '2025-06-16 12:47:32', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(12, 3, '12', '2025-06-16 12:59:19', 4, NULL, NULL, 6, 'paid', 349.99, 0.00, NULL, 349.99, 349.99, '2025-06-16 12:54:56', '2025-06-16 13:03:06', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(13, 3, '12', '2025-06-16 13:16:15', 4, NULL, NULL, 6, 'paid', 729.99, 0.00, NULL, 729.99, 729.99, '2025-06-16 12:54:56', '2025-06-16 13:18:08', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(15, 3, '13', '2025-06-16 13:26:56', 3, NULL, NULL, 6, 'paid', 190.00, 0.00, NULL, 190.00, 190.00, '2025-06-16 13:23:46', '2025-06-16 13:30:57', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(16, 3, '13', '2025-06-16 13:31:40', 3, NULL, NULL, NULL, 'paid', 190.00, 0.00, NULL, 190.00, 190.00, '2025-06-16 13:23:46', '2025-06-16 13:33:14', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(17, 3, '14', '2025-06-16 13:35:43', 3, NULL, NULL, NULL, 'pending_verification', 400.00, 0.00, NULL, 400.00, 0.00, '2025-06-16 13:35:43', '2025-06-16 13:36:26', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'placed', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(18, 3, '15', '2025-06-16 13:36:32', 2, NULL, NULL, NULL, 'paid', 800.00, 0.00, NULL, 800.00, 1600.00, '2025-06-16 13:36:32', '2025-06-16 13:41:10', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(19, 3, '16', '2025-06-16 13:45:44', 3, NULL, NULL, 6, 'paid', 400.00, 0.00, NULL, 400.00, 400.00, '2025-06-16 13:43:15', '2025-06-16 13:47:27', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(20, 3, '17', '2025-06-16 13:51:10', 3, NULL, NULL, 6, 'paid', 380.00, 0.00, NULL, 380.00, 380.00, '2025-06-16 13:48:39', '2025-06-16 13:51:33', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(21, 3, '18', '2025-06-17 16:41:38', NULL, NULL, NULL, NULL, 'kot', 390.00, 0.00, NULL, 390.00, 0.00, '2025-06-17 16:41:38', '2025-06-17 16:41:38', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'placed', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(22, 3, '19', '2025-06-19 10:02:34', NULL, NULL, NULL, NULL, 'kot', 380.00, 0.00, NULL, 380.00, 0.00, '2025-06-19 10:02:34', '2025-06-19 10:02:34', 'pickup', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'placed', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(23, 3, '20', '2025-06-19 10:04:42', 1, NULL, NULL, NULL, 'kot', 739.99, 0.00, NULL, 739.99, 0.00, '2025-06-19 10:04:42', '2025-06-19 10:11:19', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'placed', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(24, 3, '21', '2025-06-19 10:14:13', NULL, NULL, NULL, NULL, 'paid', 9.99, 0.00, NULL, 9.99, 9.99, '2025-06-19 10:10:00', '2025-06-19 10:14:46', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'preparing', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(25, 3, '22', '2025-06-19 10:14:16', NULL, NULL, NULL, 6, 'kot', 1380.00, 0.00, NULL, 1380.00, 0.00, '2025-06-19 10:14:16', '2025-06-19 10:16:44', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'confirmed', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(26, 3, '23', '2025-07-29 02:09:28', 4, NULL, NULL, 6, 'paid', 539.99, 0.00, NULL, 539.99, 539.99, '2025-06-19 10:47:55', '2025-07-29 02:10:03', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(27, 3, '24', '2025-07-21 16:30:58', 1, NULL, NULL, NULL, 'kot', 939.99, 0.00, NULL, 939.99, 0.00, '2025-07-21 16:30:58', '2025-07-21 16:40:03', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'confirmed', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL),
(28, 3, '25', '2025-07-21 16:51:45', 6, NULL, NULL, 6, 'paid', 780.00, 0.00, NULL, 780.00, 780.00, '2025-07-21 16:44:19', '2025-07-21 16:52:34', 'dine_in', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'served', 0.00, NULL, NULL, 1, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `order_charges`
--

CREATE TABLE `order_charges` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `order_id` bigint(20) UNSIGNED NOT NULL,
  `charge_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `order_histories`
--

CREATE TABLE `order_histories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `order_id` bigint(20) UNSIGNED NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `order_items`
--

CREATE TABLE `order_items` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `order_id` bigint(20) UNSIGNED NOT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `menu_item_id` bigint(20) UNSIGNED NOT NULL,
  `menu_item_variation_id` bigint(20) UNSIGNED DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `price` decimal(16,2) NOT NULL,
  `amount` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `order_items`
--

INSERT INTO `order_items` (`id`, `branch_id`, `order_id`, `transaction_id`, `menu_item_id`, `menu_item_variation_id`, `quantity`, `price`, `amount`, `created_at`, `updated_at`) VALUES
(4, 3, 2, NULL, 1, NULL, 1, 9.99, 9.99, '2025-05-29 15:39:55', '2025-05-29 15:39:55'),
(6, 3, 4, NULL, 2, NULL, 2, 349.99, 699.98, '2025-05-29 15:47:02', '2025-05-29 15:47:02'),
(9, 3, 6, 'TXN_684c07a401a2f8.32175591_624102', 8, NULL, 1, 200.00, 200.00, '2025-06-13 11:12:36', '2025-06-13 11:12:36'),
(14, 3, 6, 'TXN_684c0e02bab215.56197626_493642', 3, NULL, 1, 400.00, 400.00, '2025-06-13 11:39:46', '2025-06-13 11:39:46'),
(15, 3, 8, NULL, 5, NULL, 1, 290.00, 290.00, '2025-06-13 11:46:12', '2025-06-13 11:46:12'),
(16, 3, 9, 'TXN_684d42809be625.48773484_112813', 8, NULL, 1, 200.00, 200.00, '2025-06-14 09:36:00', '2025-06-14 09:36:00'),
(17, 3, 9, 'TXN_684d42809be625.48773484_112813', 4, NULL, 1, 380.00, 380.00, '2025-06-14 09:36:00', '2025-06-14 09:36:00'),
(18, 3, 5, NULL, 6, NULL, 1, 250.00, 250.00, '2025-06-16 10:08:42', '2025-06-16 10:08:42'),
(19, 3, 5, NULL, 4, NULL, 1, 380.00, 380.00, '2025-06-16 10:08:42', '2025-06-16 10:08:42'),
(20, 3, 5, NULL, 5, NULL, 1, 290.00, 290.00, '2025-06-16 10:08:42', '2025-06-16 10:08:42'),
(21, 3, 1, NULL, 3, NULL, 1, 400.00, 400.00, '2025-06-16 10:30:19', '2025-06-16 10:30:19'),
(22, 3, 10, 'TXN_685002684914b2.87875851_887950', 9, NULL, 1, 190.00, 190.00, '2025-06-16 11:39:20', '2025-06-16 11:39:20'),
(24, 3, 3, NULL, 1, NULL, 1, 9.99, 9.99, '2025-06-16 12:04:03', '2025-06-16 12:04:03'),
(25, 3, 3, NULL, 3, NULL, 1, 400.00, 400.00, '2025-06-16 12:04:03', '2025-06-16 12:04:03'),
(26, 3, 10, 'TXN_68500f7de38b33.54372554_323061', 8, NULL, 1, 200.00, 200.00, '2025-06-16 12:35:09', '2025-06-16 12:35:09'),
(28, 3, 11, NULL, 8, NULL, 1, 200.00, 200.00, '2025-06-16 12:44:00', '2025-06-16 12:44:00'),
(31, 3, 12, NULL, 2, NULL, 1, 349.99, 349.99, '2025-06-16 12:59:19', '2025-06-16 12:59:19'),
(33, 3, 13, NULL, 2, NULL, 1, 349.99, 349.99, '2025-06-16 13:16:15', '2025-06-16 13:16:15'),
(34, 3, 13, NULL, 4, NULL, 1, 380.00, 380.00, '2025-06-16 13:16:15', '2025-06-16 13:16:15'),
(38, 3, 15, NULL, 9, NULL, 1, 190.00, 190.00, '2025-06-16 13:26:56', '2025-06-16 13:26:56'),
(39, 3, 16, NULL, 9, NULL, 1, 190.00, 190.00, '2025-06-16 13:31:40', '2025-06-16 13:31:40'),
(40, 3, 17, 'TXN_68501daf8dae09.14752966_815639', 3, NULL, 1, 400.00, 400.00, '2025-06-16 13:35:43', '2025-06-16 13:35:43'),
(41, 3, 18, 'TXN_68501de00a5828.96329917_755786', 8, NULL, 4, 200.00, 800.00, '2025-06-16 13:36:32', '2025-06-16 13:36:32'),
(43, 3, 19, NULL, 11, NULL, 1, 400.00, 400.00, '2025-06-16 13:45:44', '2025-06-16 13:45:44'),
(45, 3, 20, NULL, 9, NULL, 2, 190.00, 380.00, '2025-06-16 13:51:10', '2025-06-16 13:51:10'),
(46, 3, 21, 'TXN_68519ac29ef1b7.61805166_722210', 9, NULL, 1, 190.00, 190.00, '2025-06-17 16:41:38', '2025-06-17 16:41:38'),
(47, 3, 21, 'TXN_68519ac29ef1b7.61805166_722210', 8, NULL, 1, 200.00, 200.00, '2025-06-17 16:41:38', '2025-06-17 16:41:38'),
(48, 3, 22, 'TXN_6853e03a305e02.41204263_882236', 9, NULL, 2, 190.00, 380.00, '2025-06-19 10:02:34', '2025-06-19 10:02:34'),
(49, 3, 23, 'TXN_6853e0bac2a347.97477176_447752', 8, NULL, 1, 200.00, 200.00, '2025-06-19 10:04:42', '2025-06-19 10:04:42'),
(51, 3, 23, 'TXN_6853e247e1e5c0.75061441_693230', 9, NULL, 1, 190.00, 190.00, '2025-06-19 10:11:19', '2025-06-19 10:11:19'),
(52, 3, 23, 'TXN_6853e247e1e5c0.75061441_693230', 2, NULL, 1, 349.99, 349.99, '2025-06-19 10:11:19', '2025-06-19 10:11:19'),
(53, 3, 24, NULL, 1, NULL, 1, 9.99, 9.99, '2025-06-19 10:14:13', '2025-06-19 10:14:13'),
(54, 3, 25, 'TXN_6853e2f80972b6.10183473_561139', 8, NULL, 1, 200.00, 200.00, '2025-06-19 10:14:16', '2025-06-19 10:14:16'),
(55, 3, 25, 'TXN_6853e2f80972b6.10183473_561139', 9, NULL, 1, 190.00, 190.00, '2025-06-19 10:14:16', '2025-06-19 10:14:16'),
(56, 3, 25, 'TXN_6853e332c8dd57.32259557_618325', 8, NULL, 4, 200.00, 800.00, '2025-06-19 10:15:14', '2025-06-19 10:15:14'),
(57, 3, 25, 'TXN_6853e332c8dd57.32259557_618325', 9, NULL, 1, 190.00, 190.00, '2025-06-19 10:15:14', '2025-06-19 10:15:14'),
(60, 3, 27, 'TXN_687e6b426d1579.01583867_400781', 8, NULL, 1, 200.00, 200.00, '2025-07-21 16:30:58', '2025-07-21 16:30:58'),
(61, 3, 27, 'TXN_687e6b426d1579.01583867_400781', 9, NULL, 1, 190.00, 190.00, '2025-07-21 16:30:58', '2025-07-21 16:30:58'),
(62, 3, 27, 'TXN_687e6d6391df58.26437677_327426', 8, NULL, 1, 200.00, 200.00, '2025-07-21 16:40:03', '2025-07-21 16:40:03'),
(63, 3, 27, 'TXN_687e6d6391df58.26437677_327426', 2, NULL, 1, 349.99, 349.99, '2025-07-21 16:40:03', '2025-07-21 16:40:03'),
(66, 3, 28, NULL, 3, NULL, 1, 400.00, 400.00, '2025-07-21 16:51:45', '2025-07-21 16:51:45'),
(67, 3, 28, NULL, 4, NULL, 1, 380.00, 380.00, '2025-07-21 16:51:45', '2025-07-21 16:51:45'),
(68, 3, 7, NULL, 8, NULL, 1, 200.00, 200.00, '2025-07-29 02:02:12', '2025-07-29 02:02:12'),
(69, 3, 7, NULL, 5, NULL, 1, 290.00, 290.00, '2025-07-29 02:02:12', '2025-07-29 02:02:12'),
(70, 3, 7, NULL, 1, NULL, 1, 9.99, 9.99, '2025-07-29 02:02:12', '2025-07-29 02:02:12'),
(71, 3, 7, NULL, 11, NULL, 1, 400.00, 400.00, '2025-07-29 02:02:12', '2025-07-29 02:02:12'),
(72, 3, 26, NULL, 2, NULL, 1, 349.99, 349.99, '2025-07-29 02:09:28', '2025-07-29 02:09:28'),
(73, 3, 26, NULL, 9, NULL, 1, 190.00, 190.00, '2025-07-29 02:09:28', '2025-07-29 02:09:28');

-- --------------------------------------------------------

--
-- Table structure for table `order_item_modifier_options`
--

CREATE TABLE `order_item_modifier_options` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `order_item_id` bigint(20) UNSIGNED NOT NULL,
  `modifier_option_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `order_taxes`
--

CREATE TABLE `order_taxes` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `order_id` bigint(20) UNSIGNED NOT NULL,
  `tax_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `packages`
--

CREATE TABLE `packages` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `package_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `currency_id` bigint(20) UNSIGNED DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `annual_price` decimal(16,2) DEFAULT NULL,
  `monthly_price` decimal(16,2) DEFAULT NULL,
  `monthly_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '1',
  `annual_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT '1',
  `stripe_annual_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_monthly_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_annual_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_monthly_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flutterwave_annual_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flutterwave_monthly_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_annual_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `paystack_monthly_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_lifetime_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_lifetime_plan_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `billing_cycle` tinyint(3) UNSIGNED DEFAULT NULL,
  `sort_order` int(10) UNSIGNED DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT '0',
  `is_free` tinyint(1) NOT NULL DEFAULT '0',
  `is_recommended` tinyint(1) NOT NULL DEFAULT '0',
  `package_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'standard',
  `trial_status` tinyint(1) DEFAULT NULL,
  `trial_days` int(11) DEFAULT NULL,
  `trial_notification_before_days` int(11) DEFAULT NULL,
  `trial_message` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_features` longtext COLLATE utf8mb4_unicode_ci,
  `branch_limit` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `packages`
--

INSERT INTO `packages` (`id`, `package_name`, `price`, `created_at`, `updated_at`, `currency_id`, `description`, `annual_price`, `monthly_price`, `monthly_status`, `annual_status`, `stripe_annual_plan_id`, `stripe_monthly_plan_id`, `razorpay_annual_plan_id`, `razorpay_monthly_plan_id`, `flutterwave_annual_plan_id`, `flutterwave_monthly_plan_id`, `paystack_annual_plan_id`, `paystack_monthly_plan_id`, `stripe_lifetime_plan_id`, `razorpay_lifetime_plan_id`, `billing_cycle`, `sort_order`, `is_private`, `is_free`, `is_recommended`, `package_type`, `trial_status`, `trial_days`, `trial_notification_before_days`, `trial_message`, `additional_features`, `branch_limit`) VALUES
(1, 'Default', 0.00, '2025-05-29 11:23:00', '2025-05-29 11:23:00', 1, 'Its a default package and cannot be deleted', NULL, NULL, '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12, 1, 0, 1, 0, 'default', NULL, NULL, NULL, NULL, NULL, NULL),
(2, 'Subscription Package', 0.00, '2025-05-29 11:23:00', '2025-05-29 11:23:00', 1, 'This is a subscription package', 100.00, 10.00, '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 10, 2, 0, 0, 1, 'standard', NULL, NULL, NULL, NULL, NULL, NULL),
(3, 'Life Time', 199.00, '2025-05-29 11:23:00', '2025-05-29 11:23:00', 1, 'This is a lifetime access package', NULL, NULL, '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 3, 0, 0, 1, 'lifetime', NULL, NULL, NULL, NULL, '[\"Change Branch\",\"Export Report\",\"Table Reservation\",\"Payment Gateway Integration\",\"Theme Setting\"]', NULL),
(4, 'Private Package', 0.00, '2025-05-29 11:23:00', '2025-05-29 11:23:00', 1, 'This is a private package', 50.00, 5.00, '1', '1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 12, 4, 1, 0, 0, 'standard', NULL, NULL, NULL, NULL, NULL, NULL),
(5, 'Trial Package', 0.00, '2025-05-29 11:23:00', '2025-05-29 11:23:00', 1, 'This is a trial package', NULL, NULL, '0', '0', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, 1, 0, 'trial', 1, 30, 5, '30 Days Free Trial', '[\"Change Branch\",\"Export Report\",\"Table Reservation\",\"Payment Gateway Integration\",\"Theme Setting\"]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `package_modules`
--

CREATE TABLE `package_modules` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `package_id` bigint(20) UNSIGNED DEFAULT NULL,
  `module_id` bigint(20) UNSIGNED DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `package_modules`
--

INSERT INTO `package_modules` (`id`, `package_id`, `module_id`, `created_at`, `updated_at`) VALUES
(1, 1, 1, NULL, NULL),
(2, 1, 2, NULL, NULL),
(3, 1, 3, NULL, NULL),
(4, 1, 4, NULL, NULL),
(5, 1, 5, NULL, NULL),
(6, 1, 6, NULL, NULL),
(7, 1, 7, NULL, NULL),
(8, 1, 8, NULL, NULL),
(9, 1, 9, NULL, NULL),
(10, 1, 10, NULL, NULL),
(11, 1, 11, NULL, NULL),
(12, 1, 12, NULL, NULL),
(13, 1, 13, NULL, NULL),
(14, 1, 14, NULL, NULL),
(15, 1, 15, NULL, NULL),
(16, 1, 16, NULL, NULL),
(17, 2, 1, NULL, NULL),
(18, 2, 2, NULL, NULL),
(19, 2, 3, NULL, NULL),
(20, 2, 4, NULL, NULL),
(21, 2, 5, NULL, NULL),
(22, 2, 6, NULL, NULL),
(23, 2, 7, NULL, NULL),
(24, 2, 8, NULL, NULL),
(25, 2, 9, NULL, NULL),
(26, 2, 10, NULL, NULL),
(27, 2, 11, NULL, NULL),
(28, 2, 12, NULL, NULL),
(29, 2, 13, NULL, NULL),
(30, 2, 14, NULL, NULL),
(31, 2, 15, NULL, NULL),
(32, 2, 16, NULL, NULL),
(33, 3, 1, NULL, NULL),
(34, 3, 2, NULL, NULL),
(35, 3, 3, NULL, NULL),
(36, 3, 4, NULL, NULL),
(37, 3, 5, NULL, NULL),
(38, 3, 6, NULL, NULL),
(39, 3, 7, NULL, NULL),
(40, 3, 8, NULL, NULL),
(41, 3, 9, NULL, NULL),
(42, 3, 10, NULL, NULL),
(43, 3, 11, NULL, NULL),
(44, 3, 12, NULL, NULL),
(45, 3, 13, NULL, NULL),
(46, 3, 14, NULL, NULL),
(47, 3, 15, NULL, NULL),
(48, 3, 16, NULL, NULL),
(49, 4, 1, NULL, NULL),
(50, 4, 2, NULL, NULL),
(51, 4, 3, NULL, NULL),
(52, 4, 4, NULL, NULL),
(53, 4, 5, NULL, NULL),
(54, 4, 6, NULL, NULL),
(55, 4, 7, NULL, NULL),
(56, 4, 8, NULL, NULL),
(57, 4, 9, NULL, NULL),
(58, 4, 10, NULL, NULL),
(59, 4, 11, NULL, NULL),
(60, 4, 12, NULL, NULL),
(61, 4, 13, NULL, NULL),
(62, 4, 14, NULL, NULL),
(63, 4, 15, NULL, NULL),
(64, 4, 16, NULL, NULL),
(65, 5, 1, NULL, NULL),
(66, 5, 2, NULL, NULL),
(67, 5, 3, NULL, NULL),
(68, 5, 4, NULL, NULL),
(69, 5, 5, NULL, NULL),
(70, 5, 6, NULL, NULL),
(71, 5, 7, NULL, NULL),
(72, 5, 8, NULL, NULL),
(73, 5, 9, NULL, NULL),
(74, 5, 10, NULL, NULL),
(75, 5, 11, NULL, NULL),
(76, 5, 12, NULL, NULL),
(77, 5, 13, NULL, NULL),
(78, 5, 14, NULL, NULL),
(79, 5, 15, NULL, NULL),
(80, 5, 16, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `password_reset_tokens`
--

CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `payments`
--

CREATE TABLE `payments` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `order_id` bigint(20) UNSIGNED NOT NULL,
  `payment_method` enum('cash','upi','card','due','stripe','razorpay','flutterwave','others') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'cash',
  `amount` decimal(16,2) NOT NULL,
  `balance` decimal(16,2) DEFAULT '0.00',
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `payments`
--

INSERT INTO `payments` (`id`, `branch_id`, `order_id`, `payment_method`, `amount`, `balance`, `transaction_id`, `created_at`, `updated_at`) VALUES
(1, 3, 5, 'cash', 945.00, 0.00, NULL, '2025-06-16 10:59:10', '2025-06-16 10:59:10'),
(2, 3, 1, 'cash', 400.00, 0.00, NULL, '2025-06-16 11:02:09', '2025-06-16 11:02:09'),
(3, 3, 4, 'cash', 699.98, 0.00, NULL, '2025-06-16 11:03:18', '2025-06-16 11:03:18'),
(4, 3, 11, 'cash', 200.00, 0.00, NULL, '2025-06-16 12:47:32', '2025-06-16 12:47:32'),
(5, 3, 12, 'cash', 349.99, 0.00, NULL, '2025-06-16 13:00:00', '2025-06-16 13:00:00'),
(6, 3, 13, 'cash', 729.99, 0.00, NULL, '2025-06-16 13:18:08', '2025-06-16 13:18:08'),
(7, 3, 15, 'cash', 190.00, 0.00, NULL, '2025-06-16 13:30:57', '2025-06-16 13:30:57'),
(8, 3, 16, 'cash', 190.00, 0.00, NULL, '2025-06-16 13:33:14', '2025-06-16 13:33:14'),
(9, 3, 17, 'cash', 400.00, 0.00, NULL, '2025-06-16 13:36:26', '2025-06-16 13:36:26'),
(10, 3, 18, 'cash', 800.00, 0.00, NULL, '2025-06-16 13:36:50', '2025-06-16 13:36:50'),
(11, 3, 18, 'cash', 800.00, 0.00, NULL, '2025-06-16 13:36:50', '2025-06-16 13:36:50'),
(12, 3, 19, 'cash', 400.00, 0.00, NULL, '2025-06-16 13:47:27', '2025-06-16 13:47:27'),
(13, 3, 20, 'cash', 380.00, 0.00, NULL, '2025-06-16 13:51:33', '2025-06-16 13:51:33'),
(14, 3, 24, 'cash', 9.99, 0.00, NULL, '2025-06-19 10:14:46', '2025-06-19 10:14:46'),
(15, 3, 28, 'cash', 780.00, 0.00, NULL, '2025-07-21 16:52:34', '2025-07-21 16:52:34'),
(16, 3, 7, 'cash', 899.99, 0.00, NULL, '2025-07-29 02:02:32', '2025-07-29 02:02:32'),
(17, 3, 3, 'cash', 409.99, 0.00, NULL, '2025-07-29 02:07:04', '2025-07-29 02:07:04'),
(18, 3, 26, 'cash', 539.99, 0.00, NULL, '2025-07-29 02:10:03', '2025-07-29 02:10:03');

-- --------------------------------------------------------

--
-- Table structure for table `payment_gateway_credentials`
--

CREATE TABLE `payment_gateway_credentials` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `razorpay_key` text COLLATE utf8mb4_unicode_ci,
  `razorpay_secret` text COLLATE utf8mb4_unicode_ci,
  `razorpay_status` tinyint(1) NOT NULL DEFAULT '0',
  `stripe_key` text COLLATE utf8mb4_unicode_ci,
  `stripe_secret` text COLLATE utf8mb4_unicode_ci,
  `stripe_status` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_dine_in_payment_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `is_delivery_payment_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `is_pickup_payment_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `is_cash_payment_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `is_qr_payment_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `is_offline_payment_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `offline_payment_detail` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qr_code_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flutterwave_status` tinyint(1) NOT NULL DEFAULT '0',
  `flutterwave_mode` enum('test','live') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'test',
  `test_flutterwave_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_flutterwave_secret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_flutterwave_hash` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_flutterwave_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_flutterwave_secret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `live_flutterwave_hash` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flutterwave_webhook_secret_hash` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `payment_gateway_credentials`
--

INSERT INTO `payment_gateway_credentials` (`id`, `restaurant_id`, `razorpay_key`, `razorpay_secret`, `razorpay_status`, `stripe_key`, `stripe_secret`, `stripe_status`, `created_at`, `updated_at`, `is_dine_in_payment_enabled`, `is_delivery_payment_enabled`, `is_pickup_payment_enabled`, `is_cash_payment_enabled`, `is_qr_payment_enabled`, `is_offline_payment_enabled`, `offline_payment_detail`, `qr_code_image`, `flutterwave_status`, `flutterwave_mode`, `test_flutterwave_key`, `test_flutterwave_secret`, `test_flutterwave_hash`, `live_flutterwave_key`, `live_flutterwave_secret`, `live_flutterwave_hash`, `flutterwave_webhook_secret_hash`) VALUES
(1, 1, NULL, NULL, 0, NULL, NULL, 0, '2025-05-29 11:23:00', '2025-05-29 11:23:00', 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 'test', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, 1, NULL, NULL, 0, NULL, NULL, 0, '2025-05-29 11:23:00', '2025-05-29 11:23:00', 0, 0, 0, 0, 0, 0, NULL, NULL, 0, 'test', NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(3, 2, NULL, NULL, 0, NULL, NULL, 0, '2025-05-29 12:11:59', '2025-06-16 13:37:36', 0, 0, 0, 1, 0, 0, '1234567890', NULL, 0, 'test', NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `permissions`
--

CREATE TABLE `permissions` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `permissions`
--

INSERT INTO `permissions` (`id`, `name`, `guard_name`, `module_id`, `created_at`, `updated_at`) VALUES
(1, 'Create Menu', 'web', 1, NULL, NULL),
(2, 'Show Menu', 'web', 1, NULL, NULL),
(3, 'Update Menu', 'web', 1, NULL, NULL),
(4, 'Delete Menu', 'web', 1, NULL, NULL),
(5, 'Create Menu Item', 'web', 2, NULL, NULL),
(6, 'Show Menu Item', 'web', 2, NULL, NULL),
(7, 'Update Menu Item', 'web', 2, NULL, NULL),
(8, 'Delete Menu Item', 'web', 2, NULL, NULL),
(9, 'Create Item Category', 'web', 3, NULL, NULL),
(10, 'Show Item Category', 'web', 3, NULL, NULL),
(11, 'Update Item Category', 'web', 3, NULL, NULL),
(12, 'Delete Item Category', 'web', 3, NULL, NULL),
(13, 'Create Area', 'web', 4, NULL, NULL),
(14, 'Show Area', 'web', 4, NULL, NULL),
(15, 'Update Area', 'web', 4, NULL, NULL),
(16, 'Delete Area', 'web', 4, NULL, NULL),
(17, 'Create Table', 'web', 5, NULL, NULL),
(18, 'Show Table', 'web', 5, NULL, NULL),
(19, 'Update Table', 'web', 5, NULL, NULL),
(20, 'Delete Table', 'web', 5, NULL, NULL),
(21, 'Create Reservation', 'web', 6, NULL, NULL),
(22, 'Show Reservation', 'web', 6, NULL, NULL),
(23, 'Update Reservation', 'web', 6, NULL, NULL),
(24, 'Delete Reservation', 'web', 6, NULL, NULL),
(25, 'Manage KOT', 'web', 7, NULL, NULL),
(26, 'Create Order', 'web', 8, NULL, NULL),
(27, 'Show Order', 'web', 8, NULL, NULL),
(28, 'Update Order', 'web', 8, NULL, NULL),
(29, 'Delete Order', 'web', 8, NULL, NULL),
(30, 'Create Customer', 'web', 9, NULL, NULL),
(31, 'Show Customer', 'web', 9, NULL, NULL),
(32, 'Update Customer', 'web', 9, NULL, NULL),
(33, 'Delete Customer', 'web', 9, NULL, NULL),
(34, 'Create Staff Member', 'web', 10, NULL, NULL),
(35, 'Show Staff Member', 'web', 10, NULL, NULL),
(36, 'Update Staff Member', 'web', 10, NULL, NULL),
(37, 'Delete Staff Member', 'web', 10, NULL, NULL),
(38, 'Create Delivery Executive', 'web', 14, NULL, NULL),
(39, 'Show Delivery Executive', 'web', 14, NULL, NULL),
(40, 'Update Delivery Executive', 'web', 14, NULL, NULL),
(41, 'Delete Delivery Executive', 'web', 14, NULL, NULL),
(42, 'Show Payments', 'web', 11, NULL, NULL),
(43, 'Show Reports', 'web', 12, NULL, NULL),
(44, 'Manage Settings', 'web', 13, NULL, NULL),
(45, 'Manage Waiter Request', 'web', 15, NULL, NULL),
(46, 'Create Expense', 'web', 16, NULL, NULL),
(47, 'Show Expense', 'web', 16, NULL, NULL),
(48, 'Update Expense', 'web', 16, NULL, NULL),
(49, 'Delete Expense', 'web', 16, NULL, NULL),
(50, 'Create Expense Category', 'web', 16, NULL, NULL),
(51, 'Show Expense Category', 'web', 16, NULL, NULL),
(52, 'Update Expense Category', 'web', 16, NULL, NULL),
(53, 'Delete Expense Category', 'web', 16, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `personal_access_tokens`
--

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `pusher_settings`
--

CREATE TABLE `pusher_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `beamer_status` tinyint(1) NOT NULL DEFAULT '0',
  `instance_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `beam_secret` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `pusher_settings`
--

INSERT INTO `pusher_settings` (`id`, `beamer_status`, `instance_id`, `beam_secret`, `created_at`, `updated_at`) VALUES
(1, 0, NULL, NULL, '2025-05-29 11:22:54', '2025-05-29 11:22:54'),
(2, 0, NULL, NULL, '2025-05-29 11:23:00', '2025-05-29 11:23:00');

-- --------------------------------------------------------

--
-- Table structure for table `razorpay_payments`
--

CREATE TABLE `razorpay_payments` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `order_id` bigint(20) UNSIGNED NOT NULL,
  `payment_date` datetime DEFAULT NULL,
  `amount` decimal(16,2) DEFAULT NULL,
  `payment_status` enum('pending','requested','declined','completed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `payment_error_response` text COLLATE utf8mb4_unicode_ci,
  `razorpay_order_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_signature` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `receipt_settings`
--

CREATE TABLE `receipt_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `show_customer_name` tinyint(1) NOT NULL DEFAULT '0',
  `show_customer_address` tinyint(1) NOT NULL DEFAULT '0',
  `show_table_number` tinyint(1) NOT NULL DEFAULT '0',
  `payment_qr_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `show_payment_qr_code` tinyint(1) NOT NULL DEFAULT '0',
  `show_waiter` tinyint(1) NOT NULL DEFAULT '0',
  `show_total_guest` tinyint(1) NOT NULL DEFAULT '0',
  `show_restaurant_logo` tinyint(1) NOT NULL DEFAULT '0',
  `show_tax` tinyint(1) NOT NULL DEFAULT '0',
  `show_payment_details` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `receipt_settings`
--

INSERT INTO `receipt_settings` (`id`, `restaurant_id`, `show_customer_name`, `show_customer_address`, `show_table_number`, `payment_qr_code`, `show_payment_qr_code`, `show_waiter`, `show_total_guest`, `show_restaurant_logo`, `show_tax`, `show_payment_details`, `created_at`, `updated_at`) VALUES
(1, 1, 0, 0, 0, NULL, 0, 0, 0, 0, 0, 1, '2025-05-29 11:23:00', '2025-05-29 11:23:00'),
(2, 2, 0, 0, 1, NULL, 0, 1, 0, 1, 0, 0, '2025-05-29 12:11:59', '2025-06-16 13:23:27');

-- --------------------------------------------------------

--
-- Table structure for table `reservations`
--

CREATE TABLE `reservations` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `table_id` bigint(20) UNSIGNED DEFAULT NULL,
  `customer_id` bigint(20) UNSIGNED DEFAULT NULL,
  `reservation_date_time` datetime NOT NULL,
  `party_size` int(11) NOT NULL,
  `special_requests` text COLLATE utf8mb4_unicode_ci,
  `reservation_status` enum('Pending','Confirmed','Checked_In','Cancelled','No_Show') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Confirmed',
  `reservation_slot_type` enum('Breakfast','Lunch','Dinner') COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `reservations`
--

INSERT INTO `reservations` (`id`, `branch_id`, `table_id`, `customer_id`, `reservation_date_time`, `party_size`, `special_requests`, `reservation_status`, `reservation_slot_type`, `created_at`, `updated_at`) VALUES
(1, 3, NULL, 1, '2025-05-30 20:00:00', 2, 'Need some music', 'Confirmed', 'Dinner', '2025-05-29 14:58:40', '2025-05-29 14:58:40');

-- --------------------------------------------------------

--
-- Table structure for table `reservation_settings`
--

CREATE TABLE `reservation_settings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `day_of_week` enum('Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday') COLLATE utf8mb4_unicode_ci NOT NULL,
  `time_slot_start` time NOT NULL,
  `time_slot_end` time NOT NULL,
  `time_slot_difference` int(11) NOT NULL,
  `slot_type` enum('Breakfast','Lunch','Dinner') COLLATE utf8mb4_unicode_ci NOT NULL,
  `available` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `reservation_settings`
--

INSERT INTO `reservation_settings` (`id`, `branch_id`, `day_of_week`, `time_slot_start`, `time_slot_end`, `time_slot_difference`, `slot_type`, `available`, `created_at`, `updated_at`) VALUES
(1, 1, 'Monday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(2, 1, 'Monday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(3, 1, 'Monday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(4, 1, 'Tuesday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(5, 1, 'Tuesday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(6, 1, 'Tuesday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(7, 1, 'Wednesday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(8, 1, 'Wednesday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(9, 1, 'Wednesday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(10, 1, 'Thursday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(11, 1, 'Thursday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(12, 1, 'Thursday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(13, 1, 'Friday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(14, 1, 'Friday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(15, 1, 'Friday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(16, 1, 'Saturday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(17, 1, 'Saturday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(18, 1, 'Saturday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(19, 1, 'Sunday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(20, 1, 'Sunday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(21, 1, 'Sunday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 11:23:01', '2025-05-29 11:23:01'),
(22, 3, 'Monday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(23, 3, 'Monday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(24, 3, 'Monday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(25, 3, 'Tuesday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(26, 3, 'Tuesday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(27, 3, 'Tuesday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(28, 3, 'Wednesday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(29, 3, 'Wednesday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(30, 3, 'Wednesday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(31, 3, 'Thursday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(32, 3, 'Thursday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(33, 3, 'Thursday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(34, 3, 'Friday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(35, 3, 'Friday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(36, 3, 'Friday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(37, 3, 'Saturday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(38, 3, 'Saturday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(39, 3, 'Saturday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(40, 3, 'Sunday', '08:00:00', '11:00:00', 30, 'Breakfast', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(41, 3, 'Sunday', '12:00:00', '17:00:00', 60, 'Lunch', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59'),
(42, 3, 'Sunday', '18:00:00', '22:00:00', 60, 'Dinner', 1, '2025-05-29 12:11:59', '2025-05-29 12:11:59');

-- --------------------------------------------------------

--
-- Table structure for table `restaurants`
--

CREATE TABLE `restaurants` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timezone` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme_hex` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme_rgb` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint(20) UNSIGNED NOT NULL,
  `hide_new_orders` tinyint(1) NOT NULL DEFAULT '0',
  `hide_new_reservations` tinyint(1) NOT NULL DEFAULT '0',
  `hide_new_waiter_request` tinyint(1) NOT NULL DEFAULT '0',
  `currency_id` bigint(20) UNSIGNED DEFAULT NULL,
  `license_type` enum('free','paid') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'free',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_login_required` tinyint(1) NOT NULL DEFAULT '0',
  `about_us` longtext COLLATE utf8mb4_unicode_ci,
  `allow_customer_delivery_orders` tinyint(1) NOT NULL DEFAULT '1',
  `allow_customer_pickup_orders` tinyint(1) NOT NULL DEFAULT '1',
  `allow_customer_orders` tinyint(1) NOT NULL DEFAULT '1',
  `allow_dine_in_orders` tinyint(1) NOT NULL DEFAULT '1',
  `package_id` bigint(20) UNSIGNED DEFAULT NULL,
  `package_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('active','inactive','license_expired') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `license_expire_on` datetime DEFAULT NULL,
  `trial_ends_at` datetime DEFAULT NULL,
  `license_updated_at` datetime DEFAULT NULL,
  `subscription_updated_at` datetime DEFAULT NULL,
  `stripe_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pm_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pm_last_four` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_waiter_request_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `default_table_reservation_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Confirmed',
  `approval_status` enum('Pending','Approved','Rejected') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Approved',
  `rejection_reason` text COLLATE utf8mb4_unicode_ci,
  `facebook_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `instagram_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twitter_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `yelp_link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_required` tinyint(1) NOT NULL DEFAULT '0',
  `show_logo_text` tinyint(1) NOT NULL DEFAULT '1',
  `meta_keyword` text COLLATE utf8mb4_unicode_ci,
  `meta_description` longtext COLLATE utf8mb4_unicode_ci,
  `upload_fav_icon_android_chrome_192` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upload_fav_icon_android_chrome_512` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upload_fav_icon_apple_touch_icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upload_favicon_16` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `upload_favicon_32` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `favicon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_waiter_request_enabled_on_desktop` tinyint(1) NOT NULL DEFAULT '1',
  `is_waiter_request_enabled_on_mobile` tinyint(1) NOT NULL DEFAULT '1',
  `is_waiter_request_enabled_open_by_qr` tinyint(1) NOT NULL DEFAULT '0',
  `webmanifest` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_tip_shop` tinyint(1) NOT NULL DEFAULT '1',
  `enable_tip_pos` tinyint(1) NOT NULL DEFAULT '1',
  `is_pwa_install_alert_show` tinyint(1) NOT NULL DEFAULT '0',
  `auto_confirm_orders` tinyint(1) NOT NULL DEFAULT '0',
  `map_api_key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `restaurants`
--

INSERT INTO `restaurants` (`id`, `name`, `hash`, `address`, `phone_number`, `email`, `timezone`, `theme_hex`, `theme_rgb`, `logo`, `country_id`, `hide_new_orders`, `hide_new_reservations`, `hide_new_waiter_request`, `currency_id`, `license_type`, `is_active`, `created_at`, `updated_at`, `customer_login_required`, `about_us`, `allow_customer_delivery_orders`, `allow_customer_pickup_orders`, `allow_customer_orders`, `allow_dine_in_orders`, `package_id`, `package_type`, `status`, `license_expire_on`, `trial_ends_at`, `license_updated_at`, `subscription_updated_at`, `stripe_id`, `pm_type`, `pm_last_four`, `is_waiter_request_enabled`, `default_table_reservation_status`, `approval_status`, `rejection_reason`, `facebook_link`, `instagram_link`, `twitter_link`, `yelp_link`, `table_required`, `show_logo_text`, `meta_keyword`, `meta_description`, `upload_fav_icon_android_chrome_192`, `upload_fav_icon_android_chrome_512`, `upload_fav_icon_apple_touch_icon`, `upload_favicon_16`, `upload_favicon_32`, `favicon`, `is_waiter_request_enabled_on_desktop`, `is_waiter_request_enabled_on_mobile`, `is_waiter_request_enabled_open_by_qr`, `webmanifest`, `enable_tip_shop`, `enable_tip_pos`, `is_pwa_install_alert_show`, `auto_confirm_orders`, `map_api_key`) VALUES
(1, 'Demo Restaurant', 'demo-restaurant', '45297 Maximilian Camp\nMarcelinoside, WY 79418', '+19156149768', 'demo.restaurant@example.com', 'America/New_York', '#A78BFA', '167, 139, 250', NULL, 236, 0, 0, 0, 1, 'free', 1, '2025-05-29 11:23:00', '2025-06-28 00:00:06', 0, '<p class=\"text-lg text-gray-600 mb-6\">\n          Welcome to our restaurant, where great food and good vibes come together! We\'re a local, family-owned spot that loves bringing people together over delicious meals and unforgettable moments. Whether you\'re here for a quick bite, a family dinner, or a celebration, we\'re all about making your time with us special.\n        </p>\n        <p class=\"text-lg text-gray-600 mb-6\">\n          Our menu is packed with dishes made from fresh, quality ingredients because we believe food should taste as\n          good as it makes you feel. From our signature dishes to seasonal specials, there\'s always something to excite\n          your taste buds.\n        </p>\n        <p class=\"text-lg text-gray-600 mb-6\">\n          But we\'re not just about the food—we\'re about community. We love seeing familiar faces and welcoming new ones.\n          Our team is a fun, friendly bunch dedicated to serving you with a smile and making sure every visit feels like\n          coming home.\n        </p>\n        <p class=\"text-lg text-gray-600\">\n          So, come on in, grab a seat, and let us take care of the rest. We can\'t wait to share our love of food with\n          you!\n        </p>\n        <p class=\"text-lg text-gray-800 font-semibold mt-6\">See you soon! 🍽️✨</p>', 1, 1, 1, 1, 1, 'monthly', 'license_expired', '2025-07-28 00:00:00', '2025-06-28 11:23:00', '2025-05-29 11:23:00', '2025-05-29 11:23:00', NULL, NULL, NULL, 1, 'Confirmed', 'Approved', NULL, 'https://www.facebook.com/', 'https://www.instagram.com/', 'https://www.twitter.com/', NULL, 0, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 1, 0, NULL, 1, 1, 0, 0, NULL),
(2, 'Ocean Bay', 'ocean-bay', 'F8MM+XFG, Bakau', '1234567', 'oceanbay@gmail.com', 'Africa/Banjul', '#F97316', '249, 115, 22', NULL, 81, 0, 0, 0, 6, 'free', 1, '2025-05-29 12:11:59', '2025-06-20 14:33:43', 0, '<div>Welcome to Ocean Bay Hotel and Resort, your tropical haven on the stunning Gambian coastline. Nestled along the Atlantic shores, we offer a perfect blend of authentic Gambian hospitality and modern luxury. Our resort is dedicated to creating unforgettable experiences with pristine beaches, vibrant local cuisine, and a range of activities to suit every traveler. From our freshly prepared breakfasts to exquisite seafood dinners, every meal tells a story of the region’s rich culture and flavors. Our team is passionate about ensuring your stay is relaxing and memorable, whether you’re here for adventure or tranquility. Discover the heart of the Gambia with us at Ocean Bay Hotel and Resort.</div>', 1, 1, 1, 1, 5, 'free', 'active', '2030-06-28 00:00:00', '2030-06-28 00:00:00', '2025-05-29 12:11:59', '2025-05-29 12:11:59', NULL, NULL, NULL, 1, 'Confirmed', 'Approved', NULL, NULL, NULL, NULL, NULL, 0, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 1, 0, NULL, 1, 1, 0, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `restaurant_charges`
--

CREATE TABLE `restaurant_charges` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `charge_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `charge_type` enum('percent','fixed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'fixed',
  `charge_value` decimal(16,2) DEFAULT NULL,
  `order_types` json NOT NULL COMMENT 'Supported order types: DineIn, Delivery, PickUp',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `restaurant_payments`
--

CREATE TABLE `restaurant_payments` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED NOT NULL,
  `amount` decimal(16,2) NOT NULL,
  `status` enum('pending','paid','failed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `payment_source` enum('official_site','app_sumo') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'official_site',
  `razorpay_order_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `razorpay_signature` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_date_time` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `stripe_payment_intent` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_session_id` text COLLATE utf8mb4_unicode_ci,
  `package_id` bigint(20) UNSIGNED DEFAULT NULL,
  `package_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flutterwave_transaction_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `flutterwave_payment_ref` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `restaurant_taxes`
--

CREATE TABLE `restaurant_taxes` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED NOT NULL,
  `tax_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tax_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guard_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` (`id`, `name`, `display_name`, `guard_name`, `created_at`, `updated_at`, `restaurant_id`) VALUES
(1, 'Super Admin', 'Super Admin', 'web', '2025-05-29 11:23:00', '2025-05-29 11:23:00', NULL),
(2, 'Admin_1', 'Admin', 'web', '2025-05-29 11:23:00', '2025-05-29 11:23:00', 1),
(3, 'Branch Head_1', 'Branch Head', 'web', '2025-05-29 11:23:00', '2025-05-29 11:23:00', 1),
(4, 'Waiter_1', 'Waiter', 'web', '2025-05-29 11:23:00', '2025-05-29 11:23:00', 1),
(5, 'Chef_1', 'Chef', 'web', '2025-05-29 11:23:00', '2025-05-29 11:23:00', 1),
(6, 'Admin_2', 'Admin', 'web', '2025-05-29 12:12:00', '2025-05-29 12:12:00', 2),
(7, 'Branch Head_2', 'Branch Head', 'web', '2025-05-29 12:12:00', '2025-05-29 12:12:00', 2),
(8, 'Waiter_2', 'Waiter', 'web', '2025-05-29 12:12:00', '2025-05-29 12:12:00', 2),
(9, 'Chef_2', 'Chef', 'web', '2025-05-29 12:12:00', '2025-05-29 12:12:00', 2);

-- --------------------------------------------------------

--
-- Table structure for table `role_has_permissions`
--

CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) UNSIGNED NOT NULL,
  `role_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `role_has_permissions`
--

INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
(1, 2),
(2, 2),
(3, 2),
(4, 2),
(5, 2),
(6, 2),
(7, 2),
(8, 2),
(9, 2),
(10, 2),
(11, 2),
(12, 2),
(13, 2),
(14, 2),
(15, 2),
(16, 2),
(17, 2),
(18, 2),
(19, 2),
(20, 2),
(21, 2),
(22, 2),
(23, 2),
(24, 2),
(25, 2),
(26, 2),
(27, 2),
(28, 2),
(29, 2),
(30, 2),
(31, 2),
(32, 2),
(33, 2),
(34, 2),
(35, 2),
(36, 2),
(37, 2),
(38, 2),
(39, 2),
(40, 2),
(41, 2),
(42, 2),
(43, 2),
(44, 2),
(45, 2),
(46, 2),
(47, 2),
(48, 2),
(49, 2),
(50, 2),
(51, 2),
(52, 2),
(53, 2),
(1, 3),
(2, 3),
(3, 3),
(4, 3),
(5, 3),
(6, 3),
(7, 3),
(8, 3),
(9, 3),
(10, 3),
(11, 3),
(12, 3),
(13, 3),
(14, 3),
(15, 3),
(16, 3),
(17, 3),
(18, 3),
(19, 3),
(20, 3),
(21, 3),
(22, 3),
(23, 3),
(24, 3),
(25, 3),
(26, 3),
(27, 3),
(28, 3),
(29, 3),
(30, 3),
(31, 3),
(32, 3),
(33, 3),
(34, 3),
(35, 3),
(36, 3),
(37, 3),
(38, 3),
(39, 3),
(40, 3),
(41, 3),
(42, 3),
(43, 3),
(44, 3),
(45, 3),
(46, 3),
(47, 3),
(48, 3),
(49, 3),
(50, 3),
(51, 3),
(52, 3),
(53, 3),
(1, 6),
(2, 6),
(3, 6),
(4, 6),
(5, 6),
(6, 6),
(7, 6),
(8, 6),
(9, 6),
(10, 6),
(11, 6),
(12, 6),
(13, 6),
(14, 6),
(15, 6),
(16, 6),
(17, 6),
(18, 6),
(19, 6),
(20, 6),
(21, 6),
(22, 6),
(23, 6),
(24, 6),
(25, 6),
(26, 6),
(27, 6),
(28, 6),
(29, 6),
(30, 6),
(31, 6),
(32, 6),
(33, 6),
(34, 6),
(35, 6),
(36, 6),
(37, 6),
(38, 6),
(39, 6),
(40, 6),
(41, 6),
(42, 6),
(43, 6),
(44, 6),
(45, 6),
(46, 6),
(47, 6),
(48, 6),
(49, 6),
(50, 6),
(51, 6),
(52, 6),
(53, 6),
(1, 7),
(2, 7),
(3, 7),
(4, 7),
(5, 7),
(6, 7),
(7, 7),
(8, 7),
(9, 7),
(10, 7),
(11, 7),
(12, 7),
(13, 7),
(14, 7),
(15, 7),
(16, 7),
(17, 7),
(18, 7),
(19, 7),
(20, 7),
(21, 7),
(22, 7),
(23, 7),
(24, 7),
(25, 7),
(26, 7),
(27, 7),
(28, 7),
(29, 7),
(30, 7),
(31, 7),
(32, 7),
(33, 7),
(34, 7),
(35, 7),
(36, 7),
(37, 7),
(38, 7),
(39, 7),
(40, 7),
(41, 7),
(42, 7),
(43, 7),
(44, 7),
(45, 7),
(46, 7),
(47, 7),
(48, 7),
(49, 7),
(50, 7),
(51, 7),
(52, 7),
(53, 7),
(2, 8),
(6, 8),
(7, 8),
(10, 8),
(14, 8),
(18, 8),
(21, 8),
(22, 8),
(23, 8),
(24, 8),
(25, 8),
(26, 8),
(27, 8),
(28, 8),
(29, 8),
(31, 8),
(38, 8),
(39, 8),
(40, 8),
(42, 8),
(45, 8),
(1, 9),
(2, 9),
(3, 9),
(4, 9),
(5, 9),
(6, 9),
(7, 9),
(8, 9),
(9, 9),
(10, 9),
(11, 9),
(12, 9),
(25, 9),
(27, 9);

-- --------------------------------------------------------

--
-- Table structure for table `sessions`
--

CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `split_orders`
--

CREATE TABLE `split_orders` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `order_id` bigint(20) UNSIGNED NOT NULL,
  `amount` decimal(16,2) NOT NULL,
  `status` enum('pending','paid') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `payment_method` enum('cash','upi','card','due','stripe','razorpay') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'cash',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `split_order_items`
--

CREATE TABLE `split_order_items` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `split_order_id` bigint(20) UNSIGNED NOT NULL,
  `order_item_id` bigint(20) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `stripe_payments`
--

CREATE TABLE `stripe_payments` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `order_id` bigint(20) UNSIGNED NOT NULL,
  `payment_date` datetime DEFAULT NULL,
  `amount` decimal(16,2) DEFAULT NULL,
  `payment_status` enum('pending','requested','declined','completed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `payment_error_response` text COLLATE utf8mb4_unicode_ci,
  `stripe_payment_intent` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `stripe_session_id` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `superadmin_payment_gateways`
--

CREATE TABLE `superadmin_payment_gateways` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `razorpay_type` enum('test','live') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'test',
  `test_razorpay_key` text COLLATE utf8mb4_unicode_ci,
  `test_razorpay_secret` text COLLATE utf8mb4_unicode_ci,
  `razorpay_test_webhook_key` text COLLATE utf8mb4_unicode_ci,
  `live_razorpay_key` text COLLATE utf8mb4_unicode_ci,
  `live_razorpay_secret` text COLLATE utf8mb4_unicode_ci,
  `razorpay_live_webhook_key` text COLLATE utf8mb4_unicode_ci,
  `razorpay_status` tinyint(1) NOT NULL DEFAULT '0',
  `stripe_type` enum('test','live') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'test',
  `test_stripe_key` text COLLATE utf8mb4_unicode_ci,
  `test_stripe_secret` text COLLATE utf8mb4_unicode_ci,
  `stripe_test_webhook_key` text COLLATE utf8mb4_unicode_ci,
  `live_stripe_key` text COLLATE utf8mb4_unicode_ci,
  `live_stripe_secret` text COLLATE utf8mb4_unicode_ci,
  `stripe_live_webhook_key` text COLLATE utf8mb4_unicode_ci,
  `stripe_status` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `flutterwave_status` tinyint(1) NOT NULL DEFAULT '0',
  `flutterwave_type` enum('test','live') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'test',
  `test_flutterwave_key` text COLLATE utf8mb4_unicode_ci,
  `test_flutterwave_secret` text COLLATE utf8mb4_unicode_ci,
  `test_flutterwave_hash` text COLLATE utf8mb4_unicode_ci,
  `flutterwave_test_webhook_key` text COLLATE utf8mb4_unicode_ci,
  `live_flutterwave_key` text COLLATE utf8mb4_unicode_ci,
  `live_flutterwave_secret` text COLLATE utf8mb4_unicode_ci,
  `live_flutterwave_hash` text COLLATE utf8mb4_unicode_ci,
  `flutterwave_live_webhook_key` text COLLATE utf8mb4_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `superadmin_payment_gateways`
--

INSERT INTO `superadmin_payment_gateways` (`id`, `razorpay_type`, `test_razorpay_key`, `test_razorpay_secret`, `razorpay_test_webhook_key`, `live_razorpay_key`, `live_razorpay_secret`, `razorpay_live_webhook_key`, `razorpay_status`, `stripe_type`, `test_stripe_key`, `test_stripe_secret`, `stripe_test_webhook_key`, `live_stripe_key`, `live_stripe_secret`, `stripe_live_webhook_key`, `stripe_status`, `created_at`, `updated_at`, `flutterwave_status`, `flutterwave_type`, `test_flutterwave_key`, `test_flutterwave_secret`, `test_flutterwave_hash`, `flutterwave_test_webhook_key`, `live_flutterwave_key`, `live_flutterwave_secret`, `live_flutterwave_hash`, `flutterwave_live_webhook_key`) VALUES
(1, 'test', NULL, NULL, NULL, NULL, NULL, NULL, 0, 'test', NULL, NULL, NULL, NULL, NULL, NULL, 0, '2025-05-29 11:22:53', '2025-05-29 11:22:53', 0, 'test', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(2, 'test', NULL, NULL, NULL, NULL, NULL, NULL, 0, 'test', NULL, NULL, NULL, NULL, NULL, NULL, 0, '2025-05-29 11:23:00', '2025-05-29 11:23:00', 0, 'test', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `tables`
--

CREATE TABLE `tables` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `table_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('active','inactive') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `available_status` enum('available','reserved','running') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `area_id` bigint(20) UNSIGNED NOT NULL,
  `seating_capacity` tinyint(3) UNSIGNED NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `tables`
--

INSERT INTO `tables` (`id`, `branch_id`, `table_code`, `hash`, `status`, `available_status`, `area_id`, `seating_capacity`, `created_at`, `updated_at`) VALUES
(1, 3, 'T-1', '4fdf23ac75dd58334a8e12e159110759', 'active', 'available', 1, 4, '2025-05-29 13:09:25', '2025-07-29 02:07:04'),
(2, 3, 'T-2', '565b0b239b0edf6bf00d917b742afe2d', 'active', 'available', 1, 2, '2025-05-29 14:52:54', '2025-07-29 02:02:32'),
(3, 3, 'T-3', '6dc4a9ff3b8ee8a8c4213a3b72506e88', 'active', 'available', 1, 4, '2025-05-29 14:53:14', '2025-06-16 13:51:33'),
(4, 3, 'T-4', '8d7b6bdf977c6af58ac89605a6dba893', 'active', 'available', 1, 8, '2025-05-29 14:53:28', '2025-07-29 02:10:03'),
(5, 3, 'T-5', '41ceddb94fdead06bcdcd4f0611c4f93', 'active', 'available', 1, 6, '2025-05-29 14:53:39', '2025-05-29 14:53:39'),
(6, 3, 'T-01', '5a32ce1a731b365b7e2c61461c472f64', 'active', 'available', 2, 4, '2025-05-29 14:54:19', '2025-07-21 16:52:34'),
(7, 3, 'T-02', '6da0abd9802737452769565357c67b80', 'active', 'available', 2, 2, '2025-05-29 14:54:38', '2025-06-16 11:03:18'),
(8, 3, 'T-03', '9b45b2235e99b12cea04929c0c41b57c', 'active', 'available', 2, 2, '2025-05-29 14:54:52', '2025-05-29 14:54:52'),
(9, 3, 'T-04', '5df2f756265ac51b9143502c2877c541', 'active', 'available', 2, 6, '2025-05-29 14:55:07', '2025-05-29 14:55:07');

-- --------------------------------------------------------

--
-- Table structure for table `taxes`
--

CREATE TABLE `taxes` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `tax_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tax_percent` decimal(16,2) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `taxes`
--

INSERT INTO `taxes` (`id`, `restaurant_id`, `tax_name`, `tax_percent`, `created_at`, `updated_at`) VALUES
(1, 1, 'SGST', 2.50, '2025-05-29 11:23:00', '2025-05-29 11:23:00'),
(2, 1, 'CGST', 2.50, '2025-05-29 11:23:00', '2025-05-29 11:23:00');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `restaurant_id` bigint(20) UNSIGNED DEFAULT NULL,
  `branch_id` bigint(20) UNSIGNED DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `two_factor_secret` text COLLATE utf8mb4_unicode_ci,
  `two_factor_recovery_codes` text COLLATE utf8mb4_unicode_ci,
  `two_factor_confirmed_at` timestamp NULL DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_team_id` bigint(20) UNSIGNED DEFAULT NULL,
  `profile_photo_path` varchar(2048) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `locale` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `stripe_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pm_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pm_last_four` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trial_ends_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `restaurant_id`, `branch_id`, `name`, `email`, `email_verified_at`, `password`, `two_factor_secret`, `two_factor_recovery_codes`, `two_factor_confirmed_at`, `remember_token`, `current_team_id`, `profile_photo_path`, `created_at`, `updated_at`, `locale`, `stripe_id`, `pm_type`, `pm_last_four`, `trial_ends_at`) VALUES
(1, NULL, NULL, 'OceanBay Menu Scanner', 'superadmin@example.com', NULL, '$2y$12$ta.hTmHcyhuXucnLwtBHtO0VBJ1nzxPBq.lhaNdjqh2wOQt/yqLkS', NULL, NULL, NULL, NULL, NULL, 'profile-photos/9cc02faa886fd017ee8e6287b25834da.png', '2025-05-29 11:23:00', '2025-05-29 14:44:44', 'en', NULL, NULL, NULL, NULL),
(2, 1, NULL, 'John Doe', 'admin@example.com', NULL, '$2y$12$nGvWvzuS.DZyFpqg1CAo4uYroL2leDtmNF5Y3iRJ.jgZi4R2k7r2C', NULL, NULL, NULL, NULL, NULL, NULL, '2025-05-29 11:23:01', '2025-05-29 14:44:44', 'en', NULL, NULL, NULL, NULL),
(3, 1, 1, 'Jaquelyn Battle', 'waiter@example.com', NULL, '$2y$12$nKun5vE/acrQtMoF50b02u6SoJk6S3GeXPsUFoL1SAuvTyjorsyeW', NULL, NULL, NULL, NULL, NULL, NULL, '2025-05-29 11:23:01', '2025-05-29 14:44:44', 'en', NULL, NULL, NULL, NULL),
(4, 2, 3, 'OceanBay Hotel & Resort', 'oceanbay@gmail.com', NULL, '$2y$12$xGz48ENZWIp10MXRHh.ox.DxYeguSZDYYUyopqYigmH23rorDKyt.', NULL, NULL, NULL, NULL, NULL, 'profile-photos/c030c882c59d5e490a3817e946aaf880.png', '2025-05-29 12:12:00', '2025-05-29 15:54:05', 'en', NULL, NULL, NULL, NULL),
(5, 2, 3, 'Binta (Chef)', 'chef@gmail.com', NULL, '$2y$12$hGSIDSDbKAEDp8bqsuf1VeVv0RwXZ/RONC2sBZDC6eSrBZMVoYvz6', NULL, NULL, NULL, NULL, NULL, NULL, '2025-06-16 10:45:42', '2025-06-19 10:39:50', 'en', NULL, NULL, NULL, NULL),
(6, 2, 3, 'Fatou (Waiter)', 'waiter@gmail.com', NULL, '$2y$12$wktrP69NAKb9HxDEpXJu7ukQCgZgmOMGqWrTQq7GUG/zI.zDC3ieS', NULL, NULL, NULL, NULL, NULL, NULL, '2025-06-16 10:47:48', '2025-06-16 12:46:46', 'en', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `waiter_requests`
--

CREATE TABLE `waiter_requests` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `branch_id` bigint(20) UNSIGNED NOT NULL,
  `table_id` bigint(20) UNSIGNED NOT NULL,
  `status` enum('pending','completed') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `waiter_requests`
--

INSERT INTO `waiter_requests` (`id`, `branch_id`, `table_id`, `status`, `created_at`, `updated_at`) VALUES
(1, 3, 1, 'completed', '2025-05-29 13:34:53', '2025-07-29 01:59:23'),
(2, 3, 1, 'completed', '2025-06-12 16:45:17', '2025-07-29 01:59:23'),
(3, 3, 1, 'completed', '2025-06-13 11:11:30', '2025-07-29 01:59:23'),
(4, 3, 1, 'completed', '2025-06-13 11:39:11', '2025-07-29 01:59:23'),
(5, 3, 6, 'completed', '2025-06-13 11:41:35', '2025-06-16 09:59:29'),
(6, 3, 1, 'completed', '2025-06-16 10:24:54', '2025-07-29 01:59:23'),
(7, 3, 1, 'completed', '2025-06-16 10:25:27', '2025-07-29 01:59:23'),
(8, 3, 1, 'completed', '2025-06-16 11:05:38', '2025-07-29 01:59:23'),
(9, 3, 1, 'completed', '2025-06-16 11:34:10', '2025-07-29 01:59:23'),
(10, 3, 1, 'completed', '2025-06-16 11:36:52', '2025-07-29 01:59:23'),
(11, 3, 4, 'completed', '2025-06-16 12:53:27', '2025-07-29 01:59:28'),
(12, 3, 4, 'completed', '2025-06-16 13:07:54', '2025-07-29 01:59:28'),
(13, 3, 4, 'completed', '2025-06-16 13:08:34', '2025-07-29 01:59:28'),
(14, 3, 1, 'completed', '2025-06-19 10:06:25', '2025-07-29 01:59:23'),
(15, 3, 1, 'completed', '2025-06-19 10:06:32', '2025-07-29 01:59:23'),
(16, 3, 1, 'completed', '2025-06-19 10:06:39', '2025-07-29 01:59:23'),
(17, 3, 1, 'completed', '2025-06-19 10:10:13', '2025-07-29 01:59:23'),
(18, 3, 7, 'completed', '2025-06-19 10:10:24', '2025-07-29 01:59:25'),
(19, 3, 4, 'completed', '2025-06-19 10:43:04', '2025-07-29 01:59:28'),
(20, 3, 2, 'completed', '2025-06-19 10:46:05', '2025-07-29 01:59:15'),
(21, 3, 4, 'completed', '2025-06-19 10:47:31', '2025-07-29 01:59:28'),
(22, 3, 2, 'completed', '2025-06-19 10:48:42', '2025-07-29 01:59:15'),
(23, 3, 2, 'completed', '2025-06-19 10:51:07', '2025-07-29 01:59:15'),
(24, 3, 2, 'completed', '2025-06-19 10:51:50', '2025-07-29 01:59:15'),
(25, 3, 2, 'completed', '2025-06-19 11:07:32', '2025-07-29 01:59:15'),
(26, 3, 2, 'completed', '2025-07-21 16:22:47', '2025-07-29 01:59:15'),
(27, 3, 2, 'completed', '2025-07-21 16:23:39', '2025-07-29 01:59:15'),
(28, 3, 2, 'completed', '2025-07-21 16:24:05', '2025-07-29 01:59:15'),
(29, 3, 1, 'completed', '2025-07-21 16:28:13', '2025-07-29 01:59:23'),
(30, 3, 1, 'completed', '2025-07-24 14:09:35', '2025-07-29 01:59:23');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `areas`
--
ALTER TABLE `areas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `areas_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `branches`
--
ALTER TABLE `branches`
  ADD PRIMARY KEY (`id`),
  ADD KEY `branches_restaurant_id_foreign` (`restaurant_id`);

--
-- Indexes for table `branch_delivery_settings`
--
ALTER TABLE `branch_delivery_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `branch_delivery_settings_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `cache`
--
ALTER TABLE `cache`
  ADD PRIMARY KEY (`key`);

--
-- Indexes for table `cache_locks`
--
ALTER TABLE `cache_locks`
  ADD PRIMARY KEY (`key`);

--
-- Indexes for table `contacts`
--
ALTER TABLE `contacts`
  ADD PRIMARY KEY (`id`),
  ADD KEY `contacts_language_setting_id_foreign` (`language_setting_id`);

--
-- Indexes for table `countries`
--
ALTER TABLE `countries`
  ADD PRIMARY KEY (`id`),
  ADD KEY `countries_countries_code_index` (`countries_code`);

--
-- Indexes for table `currencies`
--
ALTER TABLE `currencies`
  ADD PRIMARY KEY (`id`),
  ADD KEY `currencies_restaurant_id_foreign` (`restaurant_id`);

--
-- Indexes for table `customers`
--
ALTER TABLE `customers`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `customers_phone_unique` (`phone`),
  ADD UNIQUE KEY `customers_email_unique` (`email`),
  ADD KEY `customers_restaurant_id_foreign` (`restaurant_id`);

--
-- Indexes for table `customer_addresses`
--
ALTER TABLE `customer_addresses`
  ADD PRIMARY KEY (`id`),
  ADD KEY `customer_addresses_customer_id_foreign` (`customer_id`);

--
-- Indexes for table `custom_menus`
--
ALTER TABLE `custom_menus`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `custom_menus_menu_slug_unique` (`menu_slug`);

--
-- Indexes for table `delivery_executives`
--
ALTER TABLE `delivery_executives`
  ADD PRIMARY KEY (`id`),
  ADD KEY `delivery_executives_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `delivery_fee_tiers`
--
ALTER TABLE `delivery_fee_tiers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `delivery_fee_tiers_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `email_settings`
--
ALTER TABLE `email_settings`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `expenses`
--
ALTER TABLE `expenses`
  ADD PRIMARY KEY (`id`),
  ADD KEY `expenses_expense_category_id_foreign` (`expense_category_id`),
  ADD KEY `expenses_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `expense_categories`
--
ALTER TABLE `expense_categories`
  ADD PRIMARY KEY (`id`),
  ADD KEY `expense_categories_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`);

--
-- Indexes for table `file_storage`
--
ALTER TABLE `file_storage`
  ADD PRIMARY KEY (`id`),
  ADD KEY `file_storage_restaurant_id_foreign` (`restaurant_id`);

--
-- Indexes for table `file_storage_settings`
--
ALTER TABLE `file_storage_settings`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `flags`
--
ALTER TABLE `flags`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `flutterwave_payments`
--
ALTER TABLE `flutterwave_payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `flutterwave_payments_order_id_foreign` (`order_id`);

--
-- Indexes for table `front_details`
--
ALTER TABLE `front_details`
  ADD PRIMARY KEY (`id`),
  ADD KEY `front_details_language_setting_id_foreign` (`language_setting_id`);

--
-- Indexes for table `front_faq_settings`
--
ALTER TABLE `front_faq_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `front_faq_settings_language_setting_id_foreign` (`language_setting_id`);

--
-- Indexes for table `front_features`
--
ALTER TABLE `front_features`
  ADD PRIMARY KEY (`id`),
  ADD KEY `front_features_language_setting_id_foreign` (`language_setting_id`);

--
-- Indexes for table `front_review_settings`
--
ALTER TABLE `front_review_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `front_review_settings_language_setting_id_foreign` (`language_setting_id`);

--
-- Indexes for table `global_currencies`
--
ALTER TABLE `global_currencies`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `global_invoices`
--
ALTER TABLE `global_invoices`
  ADD PRIMARY KEY (`id`),
  ADD KEY `global_invoices_restaurant_id_foreign` (`restaurant_id`),
  ADD KEY `global_invoices_currency_id_foreign` (`currency_id`),
  ADD KEY `global_invoices_package_id_foreign` (`package_id`),
  ADD KEY `global_invoices_global_subscription_id_foreign` (`global_subscription_id`),
  ADD KEY `global_invoices_offline_method_id_foreign` (`offline_method_id`);

--
-- Indexes for table `global_settings`
--
ALTER TABLE `global_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `global_settings_default_currency_id_foreign` (`default_currency_id`);

--
-- Indexes for table `global_subscriptions`
--
ALTER TABLE `global_subscriptions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `global_subscriptions_restaurant_id_foreign` (`restaurant_id`),
  ADD KEY `global_subscriptions_package_id_foreign` (`package_id`),
  ADD KEY `global_subscriptions_currency_id_foreign` (`currency_id`);

--
-- Indexes for table `item_categories`
--
ALTER TABLE `item_categories`
  ADD PRIMARY KEY (`id`),
  ADD KEY `item_categories_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `item_modifiers`
--
ALTER TABLE `item_modifiers`
  ADD PRIMARY KEY (`id`),
  ADD KEY `item_modifiers_menu_item_id_foreign` (`menu_item_id`),
  ADD KEY `item_modifiers_modifier_group_id_foreign` (`modifier_group_id`);

--
-- Indexes for table `jobs`
--
ALTER TABLE `jobs`
  ADD PRIMARY KEY (`id`),
  ADD KEY `jobs_queue_index` (`queue`);

--
-- Indexes for table `job_batches`
--
ALTER TABLE `job_batches`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `kots`
--
ALTER TABLE `kots`
  ADD PRIMARY KEY (`id`),
  ADD KEY `kots_order_id_foreign` (`order_id`),
  ADD KEY `kots_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `kot_items`
--
ALTER TABLE `kot_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `kot_items_kot_id_foreign` (`kot_id`),
  ADD KEY `kot_items_menu_item_id_foreign` (`menu_item_id`),
  ADD KEY `kot_items_menu_item_variation_id_foreign` (`menu_item_variation_id`);

--
-- Indexes for table `kot_item_modifier_options`
--
ALTER TABLE `kot_item_modifier_options`
  ADD PRIMARY KEY (`id`),
  ADD KEY `kot_item_modifier_options_kot_item_id_foreign` (`kot_item_id`),
  ADD KEY `kot_item_modifier_options_modifier_option_id_foreign` (`modifier_option_id`);

--
-- Indexes for table `language_settings`
--
ALTER TABLE `language_settings`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ltm_translations`
--
ALTER TABLE `ltm_translations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `menus`
--
ALTER TABLE `menus`
  ADD PRIMARY KEY (`id`),
  ADD KEY `menus_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `menu_items`
--
ALTER TABLE `menu_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `menu_items_menu_id_foreign` (`menu_id`),
  ADD KEY `menu_items_item_category_id_foreign` (`item_category_id`),
  ADD KEY `menu_items_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `menu_item_translations`
--
ALTER TABLE `menu_item_translations`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `menu_item_translations_menu_item_id_locale_unique` (`menu_item_id`,`locale`),
  ADD KEY `menu_item_translations_locale_index` (`locale`);

--
-- Indexes for table `menu_item_variations`
--
ALTER TABLE `menu_item_variations`
  ADD PRIMARY KEY (`id`),
  ADD KEY `menu_item_variations_menu_item_id_foreign` (`menu_item_id`);

--
-- Indexes for table `migrations`
--
ALTER TABLE `migrations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  ADD KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Indexes for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  ADD KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`);

--
-- Indexes for table `modifier_groups`
--
ALTER TABLE `modifier_groups`
  ADD PRIMARY KEY (`id`),
  ADD KEY `modifier_groups_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `modifier_options`
--
ALTER TABLE `modifier_options`
  ADD PRIMARY KEY (`id`),
  ADD KEY `modifier_options_modifier_group_id_foreign` (`modifier_group_id`);

--
-- Indexes for table `modules`
--
ALTER TABLE `modules`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `notification_settings`
--
ALTER TABLE `notification_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `notification_settings_restaurant_id_foreign` (`restaurant_id`);

--
-- Indexes for table `offline_payment_methods`
--
ALTER TABLE `offline_payment_methods`
  ADD PRIMARY KEY (`id`),
  ADD KEY `offline_payment_methods_restaurant_id_foreign` (`restaurant_id`);

--
-- Indexes for table `offline_plan_changes`
--
ALTER TABLE `offline_plan_changes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `offline_plan_changes_restaurant_id_foreign` (`restaurant_id`),
  ADD KEY `offline_plan_changes_package_id_foreign` (`package_id`),
  ADD KEY `offline_plan_changes_invoice_id_foreign` (`invoice_id`),
  ADD KEY `offline_plan_changes_offline_method_id_foreign` (`offline_method_id`);

--
-- Indexes for table `onboarding_steps`
--
ALTER TABLE `onboarding_steps`
  ADD PRIMARY KEY (`id`),
  ADD KEY `onboarding_steps_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `orders`
--
ALTER TABLE `orders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `orders_table_id_foreign` (`table_id`),
  ADD KEY `orders_waiter_id_foreign` (`waiter_id`),
  ADD KEY `orders_customer_id_foreign` (`customer_id`),
  ADD KEY `orders_branch_id_foreign` (`branch_id`),
  ADD KEY `orders_delivery_executive_id_foreign` (`delivery_executive_id`);

--
-- Indexes for table `order_charges`
--
ALTER TABLE `order_charges`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_charges_order_id_foreign` (`order_id`),
  ADD KEY `order_charges_charge_id_foreign` (`charge_id`);

--
-- Indexes for table `order_histories`
--
ALTER TABLE `order_histories`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_histories_order_id_foreign` (`order_id`);

--
-- Indexes for table `order_items`
--
ALTER TABLE `order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_items_order_id_foreign` (`order_id`),
  ADD KEY `order_items_menu_item_id_foreign` (`menu_item_id`),
  ADD KEY `order_items_menu_item_variation_id_foreign` (`menu_item_variation_id`),
  ADD KEY `order_items_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `order_item_modifier_options`
--
ALTER TABLE `order_item_modifier_options`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_item_modifier_options_order_item_id_foreign` (`order_item_id`),
  ADD KEY `order_item_modifier_options_modifier_option_id_foreign` (`modifier_option_id`);

--
-- Indexes for table `order_taxes`
--
ALTER TABLE `order_taxes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_taxes_order_id_foreign` (`order_id`),
  ADD KEY `order_taxes_tax_id_foreign` (`tax_id`);

--
-- Indexes for table `packages`
--
ALTER TABLE `packages`
  ADD PRIMARY KEY (`id`),
  ADD KEY `packages_currency_id_foreign` (`currency_id`);

--
-- Indexes for table `package_modules`
--
ALTER TABLE `package_modules`
  ADD PRIMARY KEY (`id`),
  ADD KEY `package_modules_package_id_foreign` (`package_id`),
  ADD KEY `package_modules_module_id_foreign` (`module_id`);

--
-- Indexes for table `password_reset_tokens`
--
ALTER TABLE `password_reset_tokens`
  ADD PRIMARY KEY (`email`);

--
-- Indexes for table `payments`
--
ALTER TABLE `payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `payments_order_id_foreign` (`order_id`),
  ADD KEY `payments_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `payment_gateway_credentials`
--
ALTER TABLE `payment_gateway_credentials`
  ADD PRIMARY KEY (`id`),
  ADD KEY `payment_gateway_credentials_restaurant_id_foreign` (`restaurant_id`);

--
-- Indexes for table `permissions`
--
ALTER TABLE `permissions`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`),
  ADD KEY `permissions_module_id_foreign` (`module_id`);

--
-- Indexes for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  ADD KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`);

--
-- Indexes for table `pusher_settings`
--
ALTER TABLE `pusher_settings`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `razorpay_payments`
--
ALTER TABLE `razorpay_payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `razorpay_payments_order_id_foreign` (`order_id`);

--
-- Indexes for table `receipt_settings`
--
ALTER TABLE `receipt_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `receipt_settings_restaurant_id_foreign` (`restaurant_id`);

--
-- Indexes for table `reservations`
--
ALTER TABLE `reservations`
  ADD PRIMARY KEY (`id`),
  ADD KEY `reservations_table_id_foreign` (`table_id`),
  ADD KEY `reservations_customer_id_foreign` (`customer_id`),
  ADD KEY `reservations_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `reservation_settings`
--
ALTER TABLE `reservation_settings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `reservation_settings_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `restaurants`
--
ALTER TABLE `restaurants`
  ADD PRIMARY KEY (`id`),
  ADD KEY `restaurant_settings_country_id_foreign` (`country_id`),
  ADD KEY `restaurant_settings_currency_id_foreign` (`currency_id`),
  ADD KEY `restaurants_package_id_foreign` (`package_id`);

--
-- Indexes for table `restaurant_charges`
--
ALTER TABLE `restaurant_charges`
  ADD PRIMARY KEY (`id`),
  ADD KEY `restaurant_charges_restaurant_id_foreign` (`restaurant_id`),
  ADD KEY `restaurant_charges_charge_name_index` (`charge_name`);

--
-- Indexes for table `restaurant_payments`
--
ALTER TABLE `restaurant_payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `restaurant_payments_restaurant_id_foreign` (`restaurant_id`),
  ADD KEY `restaurant_payments_package_id_foreign` (`package_id`);

--
-- Indexes for table `restaurant_taxes`
--
ALTER TABLE `restaurant_taxes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `restaurant_taxes_restaurant_id_foreign` (`restaurant_id`);

--
-- Indexes for table `roles`
--
ALTER TABLE `roles`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`),
  ADD KEY `roles_restaurant_id_foreign` (`restaurant_id`);

--
-- Indexes for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD PRIMARY KEY (`permission_id`,`role_id`),
  ADD KEY `role_has_permissions_role_id_foreign` (`role_id`);

--
-- Indexes for table `sessions`
--
ALTER TABLE `sessions`
  ADD PRIMARY KEY (`id`),
  ADD KEY `sessions_user_id_index` (`user_id`),
  ADD KEY `sessions_last_activity_index` (`last_activity`);

--
-- Indexes for table `split_orders`
--
ALTER TABLE `split_orders`
  ADD PRIMARY KEY (`id`),
  ADD KEY `split_orders_order_id_foreign` (`order_id`);

--
-- Indexes for table `split_order_items`
--
ALTER TABLE `split_order_items`
  ADD PRIMARY KEY (`id`),
  ADD KEY `split_order_items_split_order_id_foreign` (`split_order_id`),
  ADD KEY `split_order_items_order_item_id_foreign` (`order_item_id`);

--
-- Indexes for table `stripe_payments`
--
ALTER TABLE `stripe_payments`
  ADD PRIMARY KEY (`id`),
  ADD KEY `stripe_payments_order_id_foreign` (`order_id`);

--
-- Indexes for table `superadmin_payment_gateways`
--
ALTER TABLE `superadmin_payment_gateways`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `tables`
--
ALTER TABLE `tables`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tables_area_id_foreign` (`area_id`),
  ADD KEY `tables_branch_id_foreign` (`branch_id`);

--
-- Indexes for table `taxes`
--
ALTER TABLE `taxes`
  ADD PRIMARY KEY (`id`),
  ADD KEY `taxes_restaurant_id_foreign` (`restaurant_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `users_email_unique` (`email`),
  ADD KEY `users_branch_id_foreign` (`branch_id`),
  ADD KEY `users_restaurant_id_foreign` (`restaurant_id`),
  ADD KEY `users_stripe_id_index` (`stripe_id`);

--
-- Indexes for table `waiter_requests`
--
ALTER TABLE `waiter_requests`
  ADD PRIMARY KEY (`id`),
  ADD KEY `waiter_requests_branch_id_foreign` (`branch_id`),
  ADD KEY `waiter_requests_table_id_foreign` (`table_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `areas`
--
ALTER TABLE `areas`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `branches`
--
ALTER TABLE `branches`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `branch_delivery_settings`
--
ALTER TABLE `branch_delivery_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `contacts`
--
ALTER TABLE `contacts`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `countries`
--
ALTER TABLE `countries`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=250;

--
-- AUTO_INCREMENT for table `currencies`
--
ALTER TABLE `currencies`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=9;

--
-- AUTO_INCREMENT for table `customers`
--
ALTER TABLE `customers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `customer_addresses`
--
ALTER TABLE `customer_addresses`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `custom_menus`
--
ALTER TABLE `custom_menus`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `delivery_executives`
--
ALTER TABLE `delivery_executives`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `delivery_fee_tiers`
--
ALTER TABLE `delivery_fee_tiers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `email_settings`
--
ALTER TABLE `email_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `expenses`
--
ALTER TABLE `expenses`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `expense_categories`
--
ALTER TABLE `expense_categories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `failed_jobs`
--
ALTER TABLE `failed_jobs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `file_storage`
--
ALTER TABLE `file_storage`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=34;

--
-- AUTO_INCREMENT for table `file_storage_settings`
--
ALTER TABLE `file_storage_settings`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `flags`
--
ALTER TABLE `flags`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=267;

--
-- AUTO_INCREMENT for table `flutterwave_payments`
--
ALTER TABLE `flutterwave_payments`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `front_details`
--
ALTER TABLE `front_details`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `front_faq_settings`
--
ALTER TABLE `front_faq_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `front_features`
--
ALTER TABLE `front_features`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `front_review_settings`
--
ALTER TABLE `front_review_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `global_currencies`
--
ALTER TABLE `global_currencies`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `global_invoices`
--
ALTER TABLE `global_invoices`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `global_settings`
--
ALTER TABLE `global_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `global_subscriptions`
--
ALTER TABLE `global_subscriptions`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `item_categories`
--
ALTER TABLE `item_categories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `item_modifiers`
--
ALTER TABLE `item_modifiers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `jobs`
--
ALTER TABLE `jobs`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `kots`
--
ALTER TABLE `kots`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=36;

--
-- AUTO_INCREMENT for table `kot_items`
--
ALTER TABLE `kot_items`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=49;

--
-- AUTO_INCREMENT for table `kot_item_modifier_options`
--
ALTER TABLE `kot_item_modifier_options`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `language_settings`
--
ALTER TABLE `language_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;

--
-- AUTO_INCREMENT for table `ltm_translations`
--
ALTER TABLE `ltm_translations`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `menus`
--
ALTER TABLE `menus`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `menu_items`
--
ALTER TABLE `menu_items`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `menu_item_translations`
--
ALTER TABLE `menu_item_translations`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `menu_item_variations`
--
ALTER TABLE `menu_item_variations`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `migrations`
--
ALTER TABLE `migrations`
  MODIFY `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=128;

--
-- AUTO_INCREMENT for table `modifier_groups`
--
ALTER TABLE `modifier_groups`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `modifier_options`
--
ALTER TABLE `modifier_options`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `modules`
--
ALTER TABLE `modules`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=17;

--
-- AUTO_INCREMENT for table `notification_settings`
--
ALTER TABLE `notification_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=11;

--
-- AUTO_INCREMENT for table `offline_payment_methods`
--
ALTER TABLE `offline_payment_methods`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `offline_plan_changes`
--
ALTER TABLE `offline_plan_changes`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `onboarding_steps`
--
ALTER TABLE `onboarding_steps`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `orders`
--
ALTER TABLE `orders`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=29;

--
-- AUTO_INCREMENT for table `order_charges`
--
ALTER TABLE `order_charges`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `order_histories`
--
ALTER TABLE `order_histories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `order_items`
--
ALTER TABLE `order_items`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=74;

--
-- AUTO_INCREMENT for table `order_item_modifier_options`
--
ALTER TABLE `order_item_modifier_options`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `order_taxes`
--
ALTER TABLE `order_taxes`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `packages`
--
ALTER TABLE `packages`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `package_modules`
--
ALTER TABLE `package_modules`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=81;

--
-- AUTO_INCREMENT for table `payments`
--
ALTER TABLE `payments`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=19;

--
-- AUTO_INCREMENT for table `payment_gateway_credentials`
--
ALTER TABLE `payment_gateway_credentials`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `permissions`
--
ALTER TABLE `permissions`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=54;

--
-- AUTO_INCREMENT for table `personal_access_tokens`
--
ALTER TABLE `personal_access_tokens`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `pusher_settings`
--
ALTER TABLE `pusher_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `razorpay_payments`
--
ALTER TABLE `razorpay_payments`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `receipt_settings`
--
ALTER TABLE `receipt_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `reservations`
--
ALTER TABLE `reservations`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `reservation_settings`
--
ALTER TABLE `reservation_settings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=43;

--
-- AUTO_INCREMENT for table `restaurants`
--
ALTER TABLE `restaurants`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `restaurant_charges`
--
ALTER TABLE `restaurant_charges`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `restaurant_payments`
--
ALTER TABLE `restaurant_payments`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `restaurant_taxes`
--
ALTER TABLE `restaurant_taxes`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `roles`
--
ALTER TABLE `roles`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `split_orders`
--
ALTER TABLE `split_orders`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `split_order_items`
--
ALTER TABLE `split_order_items`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `stripe_payments`
--
ALTER TABLE `stripe_payments`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `superadmin_payment_gateways`
--
ALTER TABLE `superadmin_payment_gateways`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `tables`
--
ALTER TABLE `tables`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=10;

--
-- AUTO_INCREMENT for table `taxes`
--
ALTER TABLE `taxes`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `waiter_requests`
--
ALTER TABLE `waiter_requests`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=31;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `areas`
--
ALTER TABLE `areas`
  ADD CONSTRAINT `areas_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `branches`
--
ALTER TABLE `branches`
  ADD CONSTRAINT `branches_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `branch_delivery_settings`
--
ALTER TABLE `branch_delivery_settings`
  ADD CONSTRAINT `branch_delivery_settings_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `contacts`
--
ALTER TABLE `contacts`
  ADD CONSTRAINT `contacts_language_setting_id_foreign` FOREIGN KEY (`language_setting_id`) REFERENCES `language_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `currencies`
--
ALTER TABLE `currencies`
  ADD CONSTRAINT `currencies_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `customers`
--
ALTER TABLE `customers`
  ADD CONSTRAINT `customers_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `customer_addresses`
--
ALTER TABLE `customer_addresses`
  ADD CONSTRAINT `customer_addresses_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `delivery_executives`
--
ALTER TABLE `delivery_executives`
  ADD CONSTRAINT `delivery_executives_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `delivery_fee_tiers`
--
ALTER TABLE `delivery_fee_tiers`
  ADD CONSTRAINT `delivery_fee_tiers_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `expenses`
--
ALTER TABLE `expenses`
  ADD CONSTRAINT `expenses_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `expenses_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `expense_categories`
--
ALTER TABLE `expense_categories`
  ADD CONSTRAINT `expense_categories_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `file_storage`
--
ALTER TABLE `file_storage`
  ADD CONSTRAINT `file_storage_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `flutterwave_payments`
--
ALTER TABLE `flutterwave_payments`
  ADD CONSTRAINT `flutterwave_payments_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `front_details`
--
ALTER TABLE `front_details`
  ADD CONSTRAINT `front_details_language_setting_id_foreign` FOREIGN KEY (`language_setting_id`) REFERENCES `language_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `front_faq_settings`
--
ALTER TABLE `front_faq_settings`
  ADD CONSTRAINT `front_faq_settings_language_setting_id_foreign` FOREIGN KEY (`language_setting_id`) REFERENCES `language_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `front_features`
--
ALTER TABLE `front_features`
  ADD CONSTRAINT `front_features_language_setting_id_foreign` FOREIGN KEY (`language_setting_id`) REFERENCES `language_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `front_review_settings`
--
ALTER TABLE `front_review_settings`
  ADD CONSTRAINT `front_review_settings_language_setting_id_foreign` FOREIGN KEY (`language_setting_id`) REFERENCES `language_settings` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `global_invoices`
--
ALTER TABLE `global_invoices`
  ADD CONSTRAINT `global_invoices_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `global_currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `global_invoices_global_subscription_id_foreign` FOREIGN KEY (`global_subscription_id`) REFERENCES `global_subscriptions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `global_invoices_offline_method_id_foreign` FOREIGN KEY (`offline_method_id`) REFERENCES `offline_payment_methods` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `global_invoices_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `global_invoices_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `global_settings`
--
ALTER TABLE `global_settings`
  ADD CONSTRAINT `global_settings_default_currency_id_foreign` FOREIGN KEY (`default_currency_id`) REFERENCES `global_currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `global_subscriptions`
--
ALTER TABLE `global_subscriptions`
  ADD CONSTRAINT `global_subscriptions_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `global_currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `global_subscriptions_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `global_subscriptions_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `item_categories`
--
ALTER TABLE `item_categories`
  ADD CONSTRAINT `item_categories_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `item_modifiers`
--
ALTER TABLE `item_modifiers`
  ADD CONSTRAINT `item_modifiers_menu_item_id_foreign` FOREIGN KEY (`menu_item_id`) REFERENCES `menu_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `item_modifiers_modifier_group_id_foreign` FOREIGN KEY (`modifier_group_id`) REFERENCES `modifier_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `kots`
--
ALTER TABLE `kots`
  ADD CONSTRAINT `kots_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `kots_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `kot_items`
--
ALTER TABLE `kot_items`
  ADD CONSTRAINT `kot_items_kot_id_foreign` FOREIGN KEY (`kot_id`) REFERENCES `kots` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `kot_items_menu_item_id_foreign` FOREIGN KEY (`menu_item_id`) REFERENCES `menu_items` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `kot_items_menu_item_variation_id_foreign` FOREIGN KEY (`menu_item_variation_id`) REFERENCES `menu_item_variations` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `kot_item_modifier_options`
--
ALTER TABLE `kot_item_modifier_options`
  ADD CONSTRAINT `kot_item_modifier_options_kot_item_id_foreign` FOREIGN KEY (`kot_item_id`) REFERENCES `kot_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `kot_item_modifier_options_modifier_option_id_foreign` FOREIGN KEY (`modifier_option_id`) REFERENCES `modifier_options` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `menus`
--
ALTER TABLE `menus`
  ADD CONSTRAINT `menus_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `menu_items`
--
ALTER TABLE `menu_items`
  ADD CONSTRAINT `menu_items_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `menu_items_item_category_id_foreign` FOREIGN KEY (`item_category_id`) REFERENCES `item_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `menu_items_menu_id_foreign` FOREIGN KEY (`menu_id`) REFERENCES `menus` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `menu_item_translations`
--
ALTER TABLE `menu_item_translations`
  ADD CONSTRAINT `menu_item_translations_menu_item_id_foreign` FOREIGN KEY (`menu_item_id`) REFERENCES `menu_items` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `menu_item_variations`
--
ALTER TABLE `menu_item_variations`
  ADD CONSTRAINT `menu_item_variations_menu_item_id_foreign` FOREIGN KEY (`menu_item_id`) REFERENCES `menu_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `model_has_permissions`
--
ALTER TABLE `model_has_permissions`
  ADD CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `model_has_roles`
--
ALTER TABLE `model_has_roles`
  ADD CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `modifier_groups`
--
ALTER TABLE `modifier_groups`
  ADD CONSTRAINT `modifier_groups_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `modifier_options`
--
ALTER TABLE `modifier_options`
  ADD CONSTRAINT `modifier_options_modifier_group_id_foreign` FOREIGN KEY (`modifier_group_id`) REFERENCES `modifier_groups` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `notification_settings`
--
ALTER TABLE `notification_settings`
  ADD CONSTRAINT `notification_settings_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `offline_payment_methods`
--
ALTER TABLE `offline_payment_methods`
  ADD CONSTRAINT `offline_payment_methods_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `offline_plan_changes`
--
ALTER TABLE `offline_plan_changes`
  ADD CONSTRAINT `offline_plan_changes_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `global_invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `offline_plan_changes_offline_method_id_foreign` FOREIGN KEY (`offline_method_id`) REFERENCES `offline_payment_methods` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `offline_plan_changes_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `offline_plan_changes_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `onboarding_steps`
--
ALTER TABLE `onboarding_steps`
  ADD CONSTRAINT `onboarding_steps_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `orders`
--
ALTER TABLE `orders`
  ADD CONSTRAINT `orders_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `orders_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `orders_delivery_executive_id_foreign` FOREIGN KEY (`delivery_executive_id`) REFERENCES `delivery_executives` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `orders_table_id_foreign` FOREIGN KEY (`table_id`) REFERENCES `tables` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `orders_waiter_id_foreign` FOREIGN KEY (`waiter_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `order_charges`
--
ALTER TABLE `order_charges`
  ADD CONSTRAINT `order_charges_charge_id_foreign` FOREIGN KEY (`charge_id`) REFERENCES `restaurant_charges` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `order_charges_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `order_histories`
--
ALTER TABLE `order_histories`
  ADD CONSTRAINT `order_histories_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `order_items`
--
ALTER TABLE `order_items`
  ADD CONSTRAINT `order_items_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `order_items_menu_item_id_foreign` FOREIGN KEY (`menu_item_id`) REFERENCES `menu_items` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `order_items_menu_item_variation_id_foreign` FOREIGN KEY (`menu_item_variation_id`) REFERENCES `menu_item_variations` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `order_items_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `order_item_modifier_options`
--
ALTER TABLE `order_item_modifier_options`
  ADD CONSTRAINT `order_item_modifier_options_modifier_option_id_foreign` FOREIGN KEY (`modifier_option_id`) REFERENCES `modifier_options` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `order_item_modifier_options_order_item_id_foreign` FOREIGN KEY (`order_item_id`) REFERENCES `order_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `order_taxes`
--
ALTER TABLE `order_taxes`
  ADD CONSTRAINT `order_taxes_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `order_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `taxes` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `packages`
--
ALTER TABLE `packages`
  ADD CONSTRAINT `packages_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `global_currencies` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `package_modules`
--
ALTER TABLE `package_modules`
  ADD CONSTRAINT `package_modules_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `package_modules_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `payments`
--
ALTER TABLE `payments`
  ADD CONSTRAINT `payments_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `payments_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `payment_gateway_credentials`
--
ALTER TABLE `payment_gateway_credentials`
  ADD CONSTRAINT `payment_gateway_credentials_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `permissions`
--
ALTER TABLE `permissions`
  ADD CONSTRAINT `permissions_module_id_foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `razorpay_payments`
--
ALTER TABLE `razorpay_payments`
  ADD CONSTRAINT `razorpay_payments_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `receipt_settings`
--
ALTER TABLE `receipt_settings`
  ADD CONSTRAINT `receipt_settings_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `reservations`
--
ALTER TABLE `reservations`
  ADD CONSTRAINT `reservations_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `reservations_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  ADD CONSTRAINT `reservations_table_id_foreign` FOREIGN KEY (`table_id`) REFERENCES `tables` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `reservation_settings`
--
ALTER TABLE `reservation_settings`
  ADD CONSTRAINT `reservation_settings_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `restaurants`
--
ALTER TABLE `restaurants`
  ADD CONSTRAINT `restaurant_settings_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `restaurant_settings_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `restaurants_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;

--
-- Constraints for table `restaurant_charges`
--
ALTER TABLE `restaurant_charges`
  ADD CONSTRAINT `restaurant_charges_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `restaurant_payments`
--
ALTER TABLE `restaurant_payments`
  ADD CONSTRAINT `restaurant_payments_package_id_foreign` FOREIGN KEY (`package_id`) REFERENCES `packages` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `restaurant_payments_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `restaurant_taxes`
--
ALTER TABLE `restaurant_taxes`
  ADD CONSTRAINT `restaurant_taxes_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `roles`
--
ALTER TABLE `roles`
  ADD CONSTRAINT `roles_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `role_has_permissions`
--
ALTER TABLE `role_has_permissions`
  ADD CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `split_orders`
--
ALTER TABLE `split_orders`
  ADD CONSTRAINT `split_orders_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`);

--
-- Constraints for table `split_order_items`
--
ALTER TABLE `split_order_items`
  ADD CONSTRAINT `split_order_items_order_item_id_foreign` FOREIGN KEY (`order_item_id`) REFERENCES `order_items` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `split_order_items_split_order_id_foreign` FOREIGN KEY (`split_order_id`) REFERENCES `split_orders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `stripe_payments`
--
ALTER TABLE `stripe_payments`
  ADD CONSTRAINT `stripe_payments_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `tables`
--
ALTER TABLE `tables`
  ADD CONSTRAINT `tables_area_id_foreign` FOREIGN KEY (`area_id`) REFERENCES `areas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `tables_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `taxes`
--
ALTER TABLE `taxes`
  ADD CONSTRAINT `taxes_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `users`
--
ALTER TABLE `users`
  ADD CONSTRAINT `users_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `users_restaurant_id_foreign` FOREIGN KEY (`restaurant_id`) REFERENCES `restaurants` (`id`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `waiter_requests`
--
ALTER TABLE `waiter_requests`
  ADD CONSTRAINT `waiter_requests_branch_id_foreign` FOREIGN KEY (`branch_id`) REFERENCES `branches` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `waiter_requests_table_id_foreign` FOREIGN KEY (`table_id`) REFERENCES `tables` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
