<div>
    <div class="flex flex-col">
        <div class="overflow-x-auto">
            <div class="inline-block min-w-full align-middle">
                <div class="overflow-hidden shadow">
                    <table class="min-w-full divide-y divide-gray-200 table-fixed dark:divide-gray-600">
                        <thead class="bg-gray-100 dark:bg-gray-700">
                            <tr>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium ltr:text-left rtl:text-right text-gray-500 uppercase dark:text-gray-400">
                                    <?php echo app('translator')->get('app.id'); ?>
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium ltr:text-left rtl:text-right text-gray-500 uppercase dark:text-gray-400">
                                    <?php echo app('translator')->get('modules.order.amount'); ?>
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium ltr:text-left rtl:text-right text-gray-500 uppercase dark:text-gray-400">
                                    <?php echo app('translator')->get('modules.order.paymentMethod'); ?>
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium ltr:text-left rtl:text-right text-gray-500 uppercase dark:text-gray-400">
                                    <?php echo app('translator')->get('modules.order.transactionId'); ?>
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium ltr:text-left rtl:text-right text-gray-500 uppercase dark:text-gray-400">
                                    <?php echo app('translator')->get('modules.order.orderNumber'); ?>
                                </th>
                                <th scope="col"
                                    class="py-2.5 px-4 text-xs font-medium ltr:text-right rtl:text-right text-gray-500 uppercase dark:text-gray-400">
                                    <?php echo app('translator')->get('app.dateTime'); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200 dark:bg-gray-800 dark:divide-gray-700" wire:key='customer-list-<?php echo e(microtime()); ?>'>

                            <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-100 dark:hover:bg-gray-700" wire:key='customer-<?php echo e($item->id . rand(1111, 9999) . microtime()); ?>' wire:loading.class.delay='opacity-10'>
                                <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white">
                                    <?php echo e($loop->remaining+1); ?>

                                </td>
                                <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white">
                                    <?php echo e(currency_format($item->amount)); ?>

                                </td>
                                <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white flex items-center gap-1">

                                    <!--[if BLOCK]><![endif]--><?php switch($item->payment_method):
                                        case ('cash'): ?>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-cash-stack" viewBox="0 0 16 16">
                                            <path d="M1 3a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1zm7 8a2 2 0 1 0 0-4 2 2 0 0 0 0 4"/>
                                            <path d="M0 5a1 1 0 0 1 1-1h14a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H1a1 1 0 0 1-1-1zm3 0a2 2 0 0 1-2 2v4a2 2 0 0 1 2 2h10a2 2 0 0 1 2-2V7a2 2 0 0 1-2-2z"/>
                                        </svg>
                                        <?php echo e(__('modules.order.' . $item->payment_method)); ?>

                                            <?php break; ?>
                                        <?php case ('card'): ?>
                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-credit-card" viewBox="0 0 16 16">
                                            <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v1h14V4a1 1 0 0 0-1-1zm13 4H1v5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1z"/>
                                            <path d="M2 10a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1z"/>
                                        </svg>
                                        <?php echo e(__('modules.order.' . $item->payment_method)); ?>

                                        <?php break; ?>
                                        <?php case ('upi'): ?>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-qr-code-scan" viewBox="0 0 16 16">
                                                <path d="M0 .5A.5.5 0 0 1 .5 0h3a.5.5 0 0 1 0 1H1v2.5a.5.5 0 0 1-1 0zm12 0a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-1 0V1h-2.5a.5.5 0 0 1-.5-.5M.5 12a.5.5 0 0 1 .5.5V15h2.5a.5.5 0 0 1 0 1h-3a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 .5-.5m15 0a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1 0-1H15v-2.5a.5.5 0 0 1 .5-.5M4 4h1v1H4z"/>
                                                <path d="M7 2H2v5h5zM3 3h3v3H3zm2 8H4v1h1z"/>
                                                <path d="M7 9H2v5h5zm-4 1h3v3H3zm8-6h1v1h-1z"/>
                                                <path d="M9 2h5v5H9zm1 1v3h3V3zM8 8v2h1v1H8v1h2v-2h1v2h1v-1h2v-1h-3V8zm2 2H9V9h1zm4 2h-1v1h-2v1h3zm-4 2v-1H8v1z"/>
                                                <path d="M12 9h2V8h-2z"/>
                                            </svg>

                                            <?php echo e(__('modules.order.' . $item->payment_method)); ?>

                                            <?php break; ?>
                                        <?php case ('stripe'): ?>
                                        <span class="inline-flex items-center">
                                            <svg height="21" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 468 222.5" xml:space="preserve"><path d="M414 113.4c0-25.6-12.4-45.8-36.1-45.8-23.8 0-38.2 20.2-38.2 45.6 0 30.1 17 45.3 41.4 45.3 11.9 0 20.9-2.7 27.7-6.5v-20c-6.8 3.4-14.6 5.5-24.5 5.5-9.7 0-18.3-3.4-19.4-15.2h48.9c0-1.3.2-6.5.2-8.9m-49.4-9.5c0-11.3 6.9-16 13.2-16 6.1 0 12.6 4.7 12.6 16zm-63.5-36.3c-9.8 0-16.1 4.6-19.6 7.8l-1.3-6.2h-22v116.6l25-5.3.1-28.3c3.6 2.6 8.9 6.3 17.7 6.3 17.9 0 34.2-14.4 34.2-46.1-.1-29-16.6-44.8-34.1-44.8m-6 68.9c-5.9 0-9.4-2.1-11.8-4.7l-.1-37.1c2.6-2.9 6.2-4.9 11.9-4.9 9.1 0 15.4 10.2 15.4 23.3 0 13.4-6.2 23.4-15.4 23.4m-71.3-74.8 25.1-5.4V36l-25.1 5.3zm0 7.6h25.1v87.5h-25.1zm-26.9 7.4-1.6-7.4h-21.6v87.5h25V97.5c5.9-7.7 15.9-6.3 19-5.2v-23c-3.2-1.2-14.9-3.4-20.8 7.4m-50-29.1-24.4 5.2-.1 80.1c0 14.8 11.1 25.7 25.9 25.7 8.2 0 14.2-1.5 17.5-3.3V135c-3.2 1.3-19 5.9-19-8.9V90.6h19V69.3h-19zM79.3 94.7c0-3.9 3.2-5.4 8.5-5.4 7.6 0 17.2 2.3 24.8 6.4V72.2c-8.3-3.3-16.5-4.6-24.8-4.6C67.5 67.6 54 78.2 54 95.9c0 27.6 38 23.2 38 35.1 0 4.6-4 6.1-9.6 6.1-8.3 0-18.9-3.4-27.3-8v23.8c9.3 4 18.7 5.7 27.3 5.7 20.8 0 35.1-10.3 35.1-28.2-.1-29.8-38.2-24.5-38.2-35.7" style="fill-rule:evenodd;clip-rule:evenodd;fill:#635bff"/></svg>
                                        </span>
                                            <?php break; ?>
                                        <?php case ('razorpay'): ?>
                                        <span class="inline-flex items-center">
                                            <svg height="20" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 122.88 26.53" xml:space="preserve"><path d="M11.19 9.03 7.94 21.47H0l1.61-6.12zm16.9-3.95c1.86.01 3.17.42 3.91 1.25s.92 2.01.51 3.56a6.1 6.1 0 0 1-1.59 2.8c-.8.8-1.78 1.38-2.87 1.68.83.19 1.34.78 1.5 1.79l.03.22.6 5.09h-3.7l-.62-5.48a1.2 1.2 0 0 0-.15-.52c-.09-.16-.22-.29-.37-.39a2.3 2.3 0 0 0-1-.25h-2.49l-1.74 6.63h-3.46l4.3-16.38zm94.79 4.29-4.4 6.34-5.19 7.52-.04.04-1.16 1.68-.04.06-.05.08-1 1.44h-3.44l4.02-5.67-1.82-11.09h3.57l.9 7.23 4.36-6.19.06-.09.07-.1.07-.09.54-1.15h3.55zm-30.48.88a3.68 3.68 0 0 1 1.24 2.19c.18 1.07.1 2.18-.21 3.22a9.5 9.5 0 0 1-1.46 3.19 7.15 7.15 0 0 1-2.35 2.13c-.88.48-1.85.73-2.85.73a3.67 3.67 0 0 1-2.02-.51c-.47-.28-.83-.71-1.03-1.22l-.06-.2-1.77 6.75h-3.43l3.51-13.4.02-.06.01-.06.86-3.25h3.35l-.57 1.88-.01.08c.49-.7 1.15-1.27 1.91-1.64.76-.4 1.6-.6 2.45-.6.85-.05 1.71.23 2.41.77m-4.14 1.86a3 3 0 0 0-2.18.88c-.68.7-1.15 1.59-1.36 2.54-.3 1.11-.28 1.95.02 2.53s.87.88 1.72.88c.81.02 1.59-.29 2.18-.86.66-.69 1.12-1.55 1.33-2.49.29-1.09.27-1.96-.03-2.57s-.86-.91-1.68-.91m15.4-2.12c.46.29.82.72 1.02 1.23l.07.19.44-1.66h3.36l-3.08 11.7h-3.37l.45-1.73c-.51.61-1.15 1.09-1.87 1.42-.7.32-1.45.49-2.21.49-.88.04-1.76-.21-2.48-.74-.66-.52-1.1-1.28-1.24-2.11a6.94 6.94 0 0 1 .19-3.17 9.8 9.8 0 0 1 1.49-3.21c.63-.89 1.44-1.64 2.38-2.18.86-.5 1.84-.77 2.83-.77.72-.02 1.42.16 2.02.54m-1.74 2.15c-.41 0-.82.08-1.19.24-.38.16-.72.39-1.01.68-.67.71-1.15 1.59-1.36 2.55-.28 1.08-.28 1.9.04 2.49.31.59.89.87 1.75.87.4.01.8-.07 1.18-.22s.71-.38 1-.66a5.4 5.4 0 0 0 1.26-2.22l.08-.31c.3-1.11.29-1.96-.03-2.53-.31-.59-.88-.89-1.72-.89M81.13 9.63l.22.09-.86 3.19c-.49-.26-1.03-.39-1.57-.39-.82-.03-1.62.24-2.27.75-.56.48-.97 1.12-1.18 1.82l-.07.27-1.6 6.11h-3.42l3.1-11.7h3.37l-.44 1.72c.42-.58.96-1.05 1.57-1.4.68-.39 1.44-.59 2.22-.59.31-.02.63.02.93.13m-12.63.56c.76.48 1.31 1.24 1.52 2.12.25 1.06.21 2.18-.11 3.22-.3 1.18-.83 2.28-1.58 3.22-.71.91-1.61 1.63-2.64 2.12a7.75 7.75 0 0 1-3.35.73c-1.22 0-2.22-.24-3-.73a3.5 3.5 0 0 1-1.54-2.12 6.4 6.4 0 0 1 .11-3.22c.3-1.17.83-2.27 1.58-3.22.71-.9 1.62-1.63 2.66-2.12a7.8 7.8 0 0 1 3.39-.73 5.4 5.4 0 0 1 2.96.73m-3.66 1.91c-.81-.01-1.59.3-2.18.86-.61.58-1.07 1.43-1.36 2.57-.6 2.29-.02 3.43 1.74 3.43.8.02 1.57-.29 2.15-.85.6-.57 1.04-1.43 1.34-2.58.3-1.13.31-1.98.01-2.57-.29-.59-.86-.86-1.7-.86m-6.95-2.34-.6 2.32-7.55 6.67h6.06l-.72 2.73H45.05l.63-2.41 7.43-6.57h-5.65l.72-2.73h9.71zm-16.93.23c.46.29.82.72 1.02 1.23l.07.19.44-1.66h3.37l-3.07 11.7h-3.37l.45-1.73c-.51.6-1.14 1.08-1.85 1.41s-1.48.5-2.27.5a3.84 3.84 0 0 1-2.45-.74c-.66-.52-1.1-1.28-1.24-2.11a6.94 6.94 0 0 1 .19-3.17 9.6 9.6 0 0 1 1.49-3.21c.63-.89 1.44-1.64 2.37-2.18.86-.5 1.84-.76 2.83-.76.72-.02 1.42.16 2.02.53m-1.73 2.15c-.41 0-.81.08-1.19.24s-.72.39-1.01.68a5.33 5.33 0 0 0-1.36 2.55c-.28 1.08-.27 1.9.04 2.49s.89.87 1.75.87a3 3 0 0 0 2.18-.88 5.2 5.2 0 0 0 1.26-2.22l.08-.31c.29-1.11.26-1.94-.03-2.53-.31-.59-.89-.89-1.72-.89M26.85 7.81h-3.21l-1.13 4.28h3.21c1.01 0 1.81-.17 2.35-.52.57-.37.98-.95 1.13-1.63.2-.72.11-1.27-.27-1.62-.38-.33-1.07-.51-2.08-.51" style="fill:#072654"/><path style="fill:#3395ff" d="m18.4 0-5.64 21.47H8.89L12.7 6.93l-5.84 3.85L7.9 6.95z"/></svg>
                                        </span>
                                        <?php break; ?>
                                        <?php case ('flutterwave'): ?>
                                        <span class="inline-flex items-center">
                                            <svg class="w-4 h-4" width="24" height="24" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 176 144.7" xml:space="preserve"><path d="M0 31.6c0-9.4 2.7-17.4 8.5-23.1l10 10C7.4 29.6 17.1 64.1 48.8 95.8s66.2 41.4 77.3 30.3l10 10c-18.8 18.8-61.5 5.4-97.3-30.3C14 80.9 0 52.8 0 31.6" style="fill:#009a46"/><path d="M63.1 144.7c-9.4 0-17.4-2.7-23.1-8.5l10-10c11.1 11.1 45.6 1.4 77.3-30.3s41.4-66.2 30.3-77.3l10-10c18.8 18.8 5.4 61.5-30.3 97.3-24.9 24.8-53.1 38.8-74.2 38.8" style="fill:#ff5805"/><path d="M140.5 91.6C134.4 74.1 122 55.4 105.6 39 69.8 3.2 27.1-10.1 8.3 8.6 7 10 8.2 13.3 10.9 16s6.1 3.9 7.4 2.6c11.1-11.1 45.6-1.4 77.3 30.3 15 15 26.2 31.8 31.6 47.3 4.7 13.6 4.3 24.6-1.2 30.1-1.3 1.3-.2 4.6 2.6 7.4s6.1 3.9 7.4 2.6c9.6-9.7 11.2-25.6 4.5-44.7" style="fill:#f5afcb"/><path d="M167.5 8.6C157.9-1 142-2.6 122.9 4c-17.5 6.1-36.2 18.5-52.6 34.9-35.8 35.8-49.1 78.5-30.3 97.3 1.3 1.3 4.7.2 7.4-2.6s3.9-6.1 2.6-7.4c-11.1-11.1-1.4-45.6 30.3-77.3 15-15 31.8-26.2 47.2-31.6 13.6-4.7 24.6-4.3 30.1 1.2 1.3 1.3 4.6.2 7.4-2.6s3.9-5.9 2.5-7.3" style="fill:#ff9b00"/></svg>
                                        </span>
                                        <?php echo e(__('modules.order.' . $item->payment_method)); ?>

                                        <?php break; ?>
                                        <?php default: ?>

                                    <?php endswitch; ?><!--[if ENDBLOCK]><![endif]-->


                                </td>
                                <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white">
                                    <?php echo e($item->transaction_id); ?>

                                </td>
                                <td class="py-2.5 px-4 text-base text-gray-900 whitespace-nowrap dark:text-white">
                                    <a href="javascript:;" class="underline underline-offset-2 decoration-dotted"

                                    <?php if(user_can('Show Order')): ?>
                                    wire:click="$dispatch('showOrderDetail', { id: <?php echo e($item->order->id); ?> })"
                                    <?php endif; ?>

                                    ><?php echo app('translator')->get('modules.order.orderNumber'); ?> #<?php echo e($item->order->order_number); ?></a>
                                </td>
                                <td class="py-2.5 px-4 space-x-2 whitespace-nowrap text-right dark:text-white">
                                    <?php echo e($item->created_at->timezone(timezone())->translatedFormat('d M Y, h:i A')); ?>

                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr class="hover:bg-gray-100 dark:hover:bg-gray-700">
                                <td class="py-2.5 px-4 space-x-6 dark:text-white" colspan="5">
                                    <?php echo app('translator')->get('messages.noPaymentFound'); ?>
                                </td>
                            </tr>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>

    <div wire:key='payments-table-paginate-<?php echo e(microtime()); ?>'
        class="sticky bottom-0 right-0 items-center w-full p-4 bg-white border-t border-gray-200 sm:flex sm:justify-between dark:bg-gray-800 dark:border-gray-700">
        <div class="flex items-center mb-4 sm:mb-0 w-full">
            <?php echo e($payments->links()); ?>

        </div>
    </div>
</div>
<?php /**PATH /home/dovishfinancial/public_html/MENU/resources/views/livewire/payments/payments-table.blade.php ENDPATH**/ ?>