<?php

namespace App\Livewire\Dashboard;

use App\Models\Kot;
use Jantinnerezo\LivewireAlert\LivewireAlert;
use Livewire\Component;

class FoodReadyNotifications extends Component
{
    use LivewireAlert;

    protected $listeners = ['attended' => 'attended', 'newFoodReady' => 'render'];
    
    public function attended($data)
    {
        // Update KOT status to served
        Kot::where('id', $data['kotId'])->update(['status' => 'served']);
        $this->dispatch('newFoodReady');
        $this->dispatch('refreshKots'); // Refresh KOT pages if open
    }

    public function doItLater()
    {
        // Just close the popup, don't change status
        $this->dispatch('newFoodReady');
    }

    public function render()
    {
        $playSound = false;

        // Count food ready orders - same logic as waiter requests
        $count = Kot::where('status', 'food_ready')->count();
        
        // Get the most recent food ready order
        $recentKot = Kot::where('status', 'food_ready')
            ->with(['order.table', 'order.waiter'])
            ->latest()
            ->first();

        // Check if count increased (new food ready) - same pattern as waiter requests
        if (session()->has('food_ready_count') && session('food_ready_count') < $count) {
            $playSound = true;
            
            $this->dispatch('newFoodReady');

            // Show popup with same pattern as waiter requests
            if ($recentKot) {
                $tableCode = $recentKot->order->table->table_code ?? 'Takeaway';
                $orderNumber = $recentKot->order->order_number;

                $this->confirm('🍽️ Food Ready for Table ' . $tableCode . ' - Order #' . $orderNumber, [
                    'position' => 'center',
                    'confirmButtonText' => 'Mark as Served',
                    'confirmButtonColor' => '#16a34a',
                    'onConfirmed' => 'attended',
                    'showCancelButton' => true,
                    'cancelButtonText' => 'Do It Later',
                    'onCanceled' => 'doItLater',
                    'data' => [
                        'kotId' => $recentKot->id
                    ]
                ]);
            }
        }

        // Update session count - same as waiter requests
        session(['food_ready_count' => $count]);

        return view('livewire.dashboard.food-ready-notifications', [
            'count' => $count,
            'playSound' => $playSound
        ]);
    }
}