<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(isRtl() ? 'rtl' : 'ltr'); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(restaurant()->name); ?> - <?php echo app('translator')->get('modules.order.order'); ?> #<?php echo e($order->order_number); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Arial', sans-serif;
        }

        [dir="rtl"] {
            text-align: right;
        }

        [dir="ltr"] {
            text-align: left;
        }

        .receipt {
            width: 80mm;
            padding: 6.35mm;
            page-break-after: always;
        }

        .header {
            text-align: center;
            margin-bottom: 3mm;
        }

        .restaurant-logo {
            width: 20px;
            height: 20px;
            margin-top: 3px;
        }

        .restaurant-name {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 5px;
            font-size: 14pt;
            font-weight: bold;
            margin-bottom: 1mm;
        }

        .restaurant-info {
            font-size: 9pt;
            margin-bottom: 1mm;
        }

        .order-info {
            border-top: 1px dashed #000;
            border-bottom: 1px dashed #000;
            padding: 2mm 0;
            margin-bottom: 3mm;
            font-size: 9pt;
        }

        . {
            font-weight: bold;
        }

        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 3mm;
            font-size: 9pt;
        }

        .items-table th {
            padding: 1mm;
            border-bottom: 1px solid #000;
        }

        [dir="rtl"] .items-table th {
            text-align: right;
        }

        [dir="ltr"] .items-table th {
            text-align: left;
        }

        .items-table td {
            padding: 1mm 0;
            vertical-align: top;
        }

        .qty {
            width: 10%;
            text-align: center;
        }

        .description {
            width: 50%;
        }

        .payment-method {
            width: 28%;
        }

        [dir="rtl"] .price,
        [dir="rtl"] .amount {
            text-align: left;
        }

        [dir="ltr"] .price,
        [dir="ltr"] .amount {
            text-align: right;
        }

        .price {
            width: 20%;
        }

        .amount {
            width: 20%;
        }

        .summary {
            font-size: 9pt;
            margin-top: 2mm;
        }

        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 1mm;
        }

        .summary-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            justify-content: space-between;
            gap: 5px 55px;
            margin-bottom: 1mm;
        }

        .total {
            font-weight: bold;
            font-size: 11pt;
            border-top: 1px solid #000;
            padding-top: 1mm;
            margin-top: 1mm;
        }

        .footer {
            text-align: center;
            margin-top: 3mm;
            font-size: 9pt;
            padding-top: 2mm;
            border-top: 1px dashed #000;
        }

        .qr_code {
            margin-top: 5mm;
            margin-bottom: 3mm;
        }

        .modifiers {
            font-size: 8pt;
            color: #555;
        }

        @media print {
            @page {
                margin: 0;
                size: 80mm auto;
            }
        }
    </style>
</head>

<body>
    <div class="receipt">
        <div class="header">
            <div class="restaurant-name">
                <span>
                    <?php if($receiptSettings->show_restaurant_logo): ?>
                        <img src="<?php echo e(restaurant()->logo_url); ?>" alt="<?php echo e(restaurant()->name); ?>" class="restaurant-logo">
                    <?php endif; ?>
                </span>
                <span><?php echo e(restaurant()->name); ?></span>
            </div>

            <div class="restaurant-info"><?php echo e(restaurant()->address); ?></div>
            <div class="restaurant-info"><?php echo app('translator')->get('modules.customer.phone'); ?>: <?php echo e(restaurant()->phone_number); ?></div>
            <?php if($receiptSettings->show_tax): ?>

                <?php $__currentLoopData = $taxDetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $taxDetail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="restaurant-info"><?php echo e($taxDetail->tax_name); ?>: <?php echo e($taxDetail->tax_id); ?></div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

        </div>

        <div class="order-info">

            <div class="">
                <div class="summary-row">
                    <span><?php echo app('translator')->get('modules.order.orderNumber'); ?> #<span class="order-number"><?php echo e($order->order_number); ?></span></span>
                    <span class="space_left"><?php echo e($order->date_time->timezone(timezone())->translatedFormat('d M Y H:i')); ?></span>
                </div>
                <div class="summary-grid">

                    <?php if($receiptSettings->show_table_number && $order->table && $order->table->table_code): ?>
                        <span><?php echo app('translator')->get('modules.settings.tableNumber'); ?> :<span class=""><?php echo e($order->table->table_code); ?></span></span>
                    <?php endif; ?>
                    <?php if($receiptSettings->show_total_guest && $order->number_of_pax): ?>
                        <span><?php echo app('translator')->get('modules.order.noOfPax'); ?> :<span class=""><?php echo e($order->number_of_pax); ?></span></span>
                    <?php endif; ?>
                </div>

                <div class="summary-row">
                    <?php if($receiptSettings->show_waiter && $order->waiter && $order->waiter->name): ?>
                        <span><?php echo app('translator')->get('modules.order.waiter'); ?> :<span class=""><?php echo e($order->waiter->name); ?></span></span>
                    <?php endif; ?>
                </div>
                <div class="summary-row">
                    <?php if($receiptSettings->show_customer_name && $order->customer && $order->customer->name): ?>
                        <span class="showData"><?php echo app('translator')->get('modules.customer.customer'); ?> :<span class=""><?php echo e($order->customer->name); ?></span></span>
                    <?php endif; ?>
                </div>


                <?php if($receiptSettings->show_customer_address && $order->customer && $order->customer->delivery_address): ?>
                    <div class="summary-row">
                        <span><?php echo app('translator')->get('modules.customer.customerAddress'); ?> :<span class=""><?php echo e($order->customer->delivery_address); ?></span></span>
                    </div>
                <?php endif; ?>
            </div>

        </div>

        <table class="items-table">
            <thead>
                <tr>
                    <th class="qty"><?php echo app('translator')->get('modules.order.qty'); ?></th>
                    <th class="description"><?php echo app('translator')->get('modules.menu.itemName'); ?></th>
                    <th class="price"><?php echo app('translator')->get('modules.order.price'); ?></th>
                    <th class="amount"><?php echo app('translator')->get('modules.order.amount'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="qty"><?php echo e($item->quantity); ?></td>
                        <td class="description">
                            <?php echo e($item->menuItem->item_name); ?>


                            <?php if(isset($item->menuItemVariation)): ?>
                                <br><small>(<?php echo e($item->menuItemVariation->variation); ?>)</small>
                            <?php endif; ?>
                            <?php $__currentLoopData = $item->modifierOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modifier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="modifiers">• <?php echo e($modifier->name); ?>

                                    (+<?php echo e(currency_format($modifier->price)); ?>)
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </td>
                        <td class="price"><?php echo e(currency_format($item->price)); ?></td>
                        <td class="amount">
                            <?php echo e(currency_format($item->amount)); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <div class="summary">
            <div class="summary-row">
                <span><?php echo app('translator')->get('modules.order.subTotal'); ?>:</span>
                <span><?php echo e(currency_format($order->sub_total)); ?></span>
            </div>

            <?php if(!is_null($order->discount_amount)): ?>
                <div class="summary-row">
                    <span><?php echo app('translator')->get('modules.order.discount'); ?> <?php if($order->discount_type == 'percent'): ?>
                            (<?php echo e(rtrim(rtrim($order->discount_value, '0'), '.')); ?>%)
                        <?php endif; ?>
                    </span>
                    <span>-<?php echo e(currency_format($order->discount_amount)); ?></span>
                </div>
            <?php endif; ?>

            <?php $__currentLoopData = $order->charges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="summary-row">
                <span><?php echo e($item->charge->charge_name); ?>

                    <?php if($item->charge->charge_type == 'percent'): ?>
                    (<?php echo e($item->charge->charge_value); ?>%)
                    <?php endif; ?>:
                </span>
                <span>
                    <?php echo e(currency_format(($item->charge->getAmount($order->sub_total - ($order->discount_amount ?? 0))))); ?>

                </span>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if($order->tip_amount > 0): ?>
                <div class="summary-row">
                    <span><?php echo app('translator')->get('modules.order.tip'); ?>:</span>
                    <span><?php echo e(currency_format($order->tip_amount)); ?></span>
                </div>
            <?php endif; ?>

            <?php $__currentLoopData = $order->taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="summary-row">
                    <span><?php echo e($item->tax->tax_name); ?> (<?php echo e($item->tax->tax_percent); ?>%):</span>
                    <span><?php echo e(currency_format(($item->tax->tax_percent / 100) * ($order->sub_total - ($order->discount_amount ?? 0)))); ?></span>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php if($payment): ?>
                <div class="summary-row">
                    <span><?php echo app('translator')->get('modules.order.balanceReturn'); ?>:</span>
                    <span><?php echo e(currency_format($payment->balance)); ?></span>

                </div>
            <?php endif; ?>

            <div class="summary-row total">
                <span><?php echo app('translator')->get('modules.order.total'); ?>:</span>
                <span><?php echo e(currency_format($order->total)); ?></span>
            </div>

        </div>

        <div class="footer">
            <p><?php echo app('translator')->get('messages.thankYouVisit'); ?></p>
            <div>
                <?php if($receiptSettings->show_payment_qr_code): ?>
                    <p class="qr_code"><?php echo app('translator')->get('modules.settings.payFromYourPhone'); ?></p>
                    <img class="" src="<?php echo e($receiptSettings->payment_qr_code_url); ?>" alt="QR Code">
                    <p class=""><?php echo app('translator')->get('modules.settings.scanQrCode'); ?></p>
                <?php endif; ?>
            </div>
            <?php if($receiptSettings->show_payment_details && $order->payments->count()): ?>
                <div class="summary">
                    <table class="items-table">
                        <thead>
                            <tr>
                                <th class="qty"><?php echo app('translator')->get('modules.order.amount'); ?></th>
                                <th class="payment-method"><?php echo app('translator')->get('modules.order.paymentMethod'); ?></th>
                                <th class="price"><?php echo app('translator')->get('app.dateTime'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $order->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="qty"><?php echo e(currency_format($payment->amount)); ?></td>
                                    <td class="payment-method"><?php echo app('translator')->get('modules.order.' . $payment->payment_method); ?></td>
                                    <td class="price">
                                        <?php if($payment->payment_method != 'due'): ?>
                                            <?php echo e($payment->created_at->timezone(timezone())->translatedFormat('d M, Y h:i A')); ?>

                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>


    </div>

    <script>
        window.onload = function() {
            window.print();
        }
    </script>
</body>

</html>
<?php /**PATH /home/dovishfinancial/public_html/MENU/resources/views/order/print.blade.php ENDPATH**/ ?>