<div wire:poll.15s>
    @if($playSound)
        <script>
            console.log('🍽️ Playing food ready notification sound!');
            // Play notification sound - using available sound files
            var audio = new Audio("{{ asset('sound/new_order.wav') }}");
            audio.volume = 0.7;
            audio.play().catch(function(error) {
                console.log('Primary audio (new_order.wav) failed:', error);
                // Try alternative sound file
                var fallbackAudio = new Audio("{{ asset('sound/sound_beep-29.mp3') }}");
                fallbackAudio.volume = 0.7;
                fallbackAudio.play().catch(function(err) {
                    console.log('Fallback audio also failed:', err);
                });
            });
        </script>
    @endif
    
    {{-- Debug info (remove in production) --}}
    @if(app()->environment('local') || app()->environment('codecanyon'))
        <div style="display: none;" id="food-ready-debug">
            Count: {{ $count }}, PlaySound: {{ $playSound ? 'true' : 'false' }}
        </div>
    @endif
</div>